/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.overlapping;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.BitSet;
import java.util.Date;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.AnalysisProcessor;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.analysis.overlapping.OverlappingResult;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.BeanElementAdapter;

public class OverlappingProcessor
implements AnalysisProcessor {
    private OverlappingAnalysis analysis;

    public OverlappingProcessor(OverlappingAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        Date startTime = new Date();
        IMatrix data = this.analysis.getData();
        int attrIndex = 0;
        String attrName = this.analysis.getAttributeName();
        if (attrName != null && !attrName.isEmpty()) {
            attrIndex = data.getCellAttributeIndex(attrName);
        }
        if (this.analysis.isTransposeData()) {
            TransposedMatrixView mt = new TransposedMatrixView();
            mt.setMatrix(data);
            data = mt;
        }
        int numRows = data.getRowCount();
        int numColumns = data.getColumnCount();
        monitor.begin("Running Overlapping analysis ...", numColumns * (numColumns - 1) / 2);
        String[] labels = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            labels[i] = data.getColumnLabel(i);
        }
        ObjectMatrix results = new ObjectMatrix();
        this.analysis.setCellResults(results);
        results.setColumns(labels);
        results.setRows(labels);
        results.makeCells();
        results.setCellAdapter(new BeanElementAdapter(OverlappingResult.class));
        BitSet x = new BitSet(numRows);
        BitSet xna = new BitSet(numRows);
        Double replaceNanValue = this.analysis.getReplaceNanValue();
        if (replaceNanValue == null) {
            replaceNanValue = Double.NaN;
        }
        boolean cutoffEnabled = this.analysis.isBinaryCutoffEnabled();
        CutoffCmp cutoffCmp = this.analysis.getBinaryCutoffCmp();
        Double cutoffValue = this.analysis.getBinaryCutoffValue();
        Class<?> valueClass = data.getCellAttributes().get(attrIndex).getValueClass();
        MatrixUtils.DoubleCast cast = MatrixUtils.createDoubleCast(valueClass);
        for (int i = 0; i < numColumns && !monitor.isCancelled(); ++i) {
            int rowCount = 0;
            for (int row = 0; row < numRows; ++row) {
                Object value = data.getCellValue(row, i, attrIndex);
                Double v = cast.getDoubleValue(value);
                if ((v = this.transformValue(v, replaceNanValue, cutoffEnabled, cutoffCmp, cutoffValue, row, i)) == 1.0) {
                    ++rowCount;
                }
                x.set(row, v == 1.0);
                xna.set(row, Double.isNaN(v));
            }
            for (int j = i; j < numColumns && !monitor.isCancelled(); ++j) {
                monitor.info("Overlapping " + data.getColumnLabel(i) + " with " + data.getColumnLabel(j));
                int columnCount = 0;
                int bothCount = 0;
                for (int row = 0; row < numRows; ++row) {
                    double v0 = xna.get(row) ? Double.NaN : (x.get(row) ? 1.0 : 0.0);
                    Object value = data.getCellValue(row, j, attrIndex);
                    Double v1 = cast.getDoubleValue(value);
                    if ((v1 = this.transformValue(v1, replaceNanValue, cutoffEnabled, cutoffCmp, cutoffValue, row, j)) == 1.0) {
                        ++columnCount;
                    }
                    if (v0 != 1.0 || v1 != 1.0) continue;
                    ++bothCount;
                }
                results.setCell(i, j, new OverlappingResult(rowCount, columnCount, bothCount));
                monitor.worked(1);
            }
        }
        this.analysis.setStartTime(startTime);
        this.analysis.setElapsedTime(new Date().getTime() - startTime.getTime());
        monitor.end();
    }

    private Double transformValue(Double v, double replaceNanValue, boolean binaryCutoffEnabled, CutoffCmp cutoffCmp, Double cutoffValue, int row, int column) throws AnalysisException {
        boolean isNaN;
        boolean bl = isNaN = v != null ? Double.isNaN(v) : true;
        if (isNaN) {
            v = replaceNanValue;
        }
        if (!isNaN && binaryCutoffEnabled) {
            v = cutoffCmp.compare(v, cutoffValue) ? 1.0 : 0.0;
        }
        if (!isNaN && v != 1.0 && v != 0.0) {
            throw new AnalysisException("Not binary value found at row " + row + " column " + column);
        }
        return v;
    }
}

