/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.overlapping;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.Properties;
import org.gitools.analysis.AnalysisCommand;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.analysis.overlapping.OverlappingProcessor;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ResourceRef;
import org.gitools.persistence.PersistenceManager;

public class OverlappingCommand
extends AnalysisCommand {
    private OverlappingAnalysis analysis;

    public OverlappingCommand(OverlappingAnalysis analysis, String workdir, String fileName) {
        super(workdir, fileName);
        this.analysis = analysis;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        try {
            if (this.analysis.getData() == null) {
                ResourceRef res = this.analysis.getSourceDataResource();
                String dataPath = res.getPath();
                String dataMime = res.getMime();
                BaseMatrix data = this.loadDataMatrix(new File(dataPath), dataMime, new Properties(), monitor);
                this.analysis.setData(data);
            }
            OverlappingProcessor proc = new OverlappingProcessor(this.analysis);
            proc.run(monitor);
            if (this.storeAnalysis) {
                File workdirFile = new File(this.workdir);
                if (!workdirFile.exists()) {
                    workdirFile.mkdirs();
                }
                File file = new File(workdirFile, this.fileName);
                PersistenceManager.getDefault().store(file, this.analysis, monitor);
            }
        }
        catch (Throwable cause) {
            throw new AnalysisException(cause);
        }
    }
}

