/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.htest.oncozet;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectMatrix1D;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.Date;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.htest.HtestProcessor;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.BeanElementAdapter;
import org.gitools.model.ModuleMap;
import org.gitools.stats.mtc.MTC;
import org.gitools.stats.mtc.MTCFactory;
import org.gitools.stats.test.Test;
import org.gitools.stats.test.factory.TestFactory;
import org.gitools.stats.test.results.CommonResult;
import org.gitools.threads.ThreadManager;
import org.gitools.threads.ThreadQueue;
import org.gitools.threads.ThreadSlot;

public class OncodriveProcessor
extends HtestProcessor {
    private OncodriveAnalysis analysis;

    public OncodriveProcessor(OncodriveAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        Date startTime = new Date();
        TestFactory testFactory = TestFactory.createFactory(this.analysis.getTestConfig());
        IMatrix dataMatrix = this.analysis.getData();
        String[] labels = new String[dataMatrix.getColumnCount()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = dataMatrix.getColumnLabel(i);
        }
        ModuleMap csmap = this.analysis.getModuleMap();
        csmap = csmap != null ? csmap.remap(labels, this.analysis.getMinModuleSize(), this.analysis.getMaxModuleSize()) : new ModuleMap("All data columns", labels);
        this.analysis.setModuleMap(csmap);
        int numRows = dataMatrix.getRowCount();
        ObjectMatrix1D rowLabels = ObjectFactory1D.dense.make(numRows);
        for (int i = 0; i < numRows; ++i) {
            rowLabels.setQuick(i, (Object)dataMatrix.getRowLabel(i));
        }
        ObjectMatrix1D csetLabels = ObjectFactory1D.dense.make((Object[])csmap.getModuleNames());
        int[][] moduleColumnIndices = csmap.getAllItemIndices();
        int numCsets = csetLabels.size();
        monitor.begin("Running oncodrive analysis...", numRows * numCsets);
        Test test = testFactory.create();
        final ObjectMatrix resultsMatrix = new ObjectMatrix();
        resultsMatrix.setColumns(csetLabels);
        resultsMatrix.setRows(rowLabels);
        resultsMatrix.makeCells();
        resultsMatrix.setCellAdapter(new BeanElementAdapter(test.getResultClass()));
        int numProcs = ThreadManager.getNumThreads();
        ThreadQueue threadQueue = new ThreadQueue(numProcs);
        for (int i = 0; i < numProcs; ++i) {
            try {
                threadQueue.put(new RunSlot(threadQueue));
                continue;
            }
            catch (InterruptedException e) {
                monitor.debug("InterruptedException while initializing run queue: " + e.getLocalizedMessage());
            }
        }
        int minCsetSize = this.analysis.getMinModuleSize();
        int maxCsetSize = this.analysis.getMaxModuleSize();
        for (int csetIndex = 0; csetIndex < numCsets; ++csetIndex) {
            final int csetIdx = csetIndex;
            final String csetName = csetLabels.getQuick(csetIndex).toString();
            int[] columnIndices = moduleColumnIndices[csetIndex];
            IProgressMonitor condMonitor = monitor.subtask();
            int numColumns = columnIndices.length;
            if (numColumns >= minCsetSize && numColumns <= maxCsetSize) {
                condMonitor.begin("Column set " + csetName + "...", numRows);
                DoubleMatrix1D population = DoubleFactory1D.dense.make(numColumns * numRows);
                int k = 0;
                for (int i = 0; i < numRows; ++i) {
                    for (int j = 0; j < numColumns; ++j) {
                        population.setQuick(k++, MatrixUtils.doubleValue(dataMatrix.getCellValue(i, columnIndices[j], 0)));
                    }
                }
                population = population.viewSelection(notNaNProc);
                final DoubleMatrix1D itemValues = DoubleFactory1D.dense.make(numColumns);
                final int[] cindices = new int[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    cindices[i] = i;
                }
                for (int itemIndex = 0; itemIndex < numRows; ++itemIndex) {
                    RunSlot slot;
                    final int itemIdx = itemIndex;
                    final String itemName = rowLabels.getQuick(itemIndex).toString();
                    for (int j = 0; j < numColumns; ++j) {
                        itemValues.setQuick(j, MatrixUtils.doubleValue(dataMatrix.getCellValue(itemIndex, columnIndices[j], 0)));
                    }
                    try {
                        slot = (RunSlot)threadQueue.take();
                    }
                    catch (InterruptedException ex) {
                        throw new AnalysisException(ex);
                    }
                    if (slot.population != population) {
                        slot.population = population;
                        slot.test = testFactory.create();
                        slot.test.processPopulation(csetName, population);
                    }
                    slot.execute(new Runnable(){

                        @Override
                        public void run() {
                            CommonResult result = null;
                            try {
                                result = slot.test.processTest(csetName, itemValues, itemName, cindices);
                            }
                            catch (Throwable cause) {
                                cause.printStackTrace();
                            }
                            try {
                                resultsMatrix.setCell(itemIdx, csetIdx, result);
                            }
                            catch (Throwable cause) {
                                cause.printStackTrace();
                            }
                        }
                    });
                    condMonitor.worked(1);
                }
            } else {
                condMonitor.begin("Column set " + csetName + " discarded.", 1);
            }
            condMonitor.end();
            monitor.worked(1);
        }
        ThreadManager.shutdown(monitor);
        MTC mtc = MTCFactory.createFromName(this.analysis.getMtc());
        this.multipleTestCorrection(resultsMatrix, mtc, monitor.subtask());
        this.analysis.setStartTime(startTime);
        this.analysis.setElapsedTime(new Date().getTime() - startTime.getTime());
        this.analysis.setResults(resultsMatrix);
        monitor.end();
    }

    private class RunSlot
    extends ThreadSlot {
        public DoubleMatrix1D population;
        public Test test;

        public RunSlot(ThreadQueue threadQueue) {
            super(threadQueue);
            this.population = null;
            this.test = null;
        }
    }
}

