/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.htest.oncozet;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.htest.HtestCommand;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.analysis.htest.oncozet.OncodriveProcessor;
import org.gitools.datafilters.ValueTranslator;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.xml.OncodriveAnalysisXmlPersistence;

public class OncodriveCommand
extends HtestCommand {
    protected String modulesMime;
    protected String modulesPath;

    public OncodriveCommand(OncodriveAnalysis analysis, String dataMime, String dataPath, String populationPath, Double populationDefaultValue, String modulesMime, String modulesFile, String workdir, String fileName) {
        super(analysis, dataMime, dataPath, populationPath, populationDefaultValue, workdir, fileName);
        this.modulesMime = modulesMime;
        this.modulesPath = modulesFile;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        try {
            OncodriveAnalysis oncozAnalysis = (OncodriveAnalysis)this.analysis;
            monitor.begin("Loading ...", 1);
            monitor.info("Data: " + this.dataPath);
            monitor.info("Columns: " + this.modulesPath);
            this.loadDataAndModules(this.dataMime, this.dataPath, this.populationPath, this.modulesMime, this.modulesPath, oncozAnalysis, monitor.subtask());
            monitor.end();
            OncodriveProcessor processor = new OncodriveProcessor(oncozAnalysis);
            processor.run(monitor);
            this.save(oncozAnalysis, monitor);
        }
        catch (Exception ex) {
            throw new AnalysisException(ex);
        }
    }

    private void loadDataAndModules(String dataFileMime, String dataFileName, String populationFileName, String modulesFileMime, String modulesFileName, OncodriveAnalysis analysis, IProgressMonitor monitor) throws PersistenceException {
        String[] populationLabels = null;
        if (populationFileName != null) {
            File bgFile = new File(populationFileName);
            List popLabels = (List)PersistenceManager.getDefault().load(bgFile, "application/gitools-grp", monitor);
            populationLabels = popLabels.toArray(new String[popLabels.size()]);
        }
        File dataFile = new File(dataFileName);
        ValueTranslator valueTranslator = this.createValueTranslator(analysis.isBinaryCutoffEnabled(), analysis.getBinaryCutoffCmp(), analysis.getBinaryCutoffValue());
        Properties dataProps = new Properties();
        dataProps.put("binary_values", (Object)analysis.isBinaryCutoffEnabled());
        dataProps.put("value_translator", valueTranslator);
        if (populationLabels != null) {
            dataProps.put("population_labels", populationLabels);
            dataProps.put("background_value", this.populationDefaultValue);
        }
        BaseMatrix dataMatrix = this.loadDataMatrix(dataFile, dataFileMime, dataProps, monitor);
        PersistenceManager.getDefault().clearEntityCache(dataMatrix);
        analysis.setData(dataMatrix);
        if (modulesFileName != null) {
            File file = new File(modulesFileName);
            Properties modProps = new Properties();
            modProps.put("item_names_filter_enabled", (Object)true);
            modProps.put("item_names", dataMatrix.getColumnStrings());
            modProps.put("min_size", (Object)analysis.getMinModuleSize());
            modProps.put("max_size", (Object)analysis.getMaxModuleSize());
            ModuleMap moduleMap = this.loadModuleMap(file, modulesFileMime, modProps, monitor);
            PersistenceManager.getDefault().clearEntityCache(moduleMap);
            analysis.setModuleMap(moduleMap);
        }
    }

    private void save(OncodriveAnalysis analysis, IProgressMonitor monitor) throws PersistenceException {
        File workdirFile = new File(this.workdir);
        if (!workdirFile.exists()) {
            workdirFile.mkdirs();
        }
        File file = new File(workdirFile, this.fileName);
        OncodriveAnalysisXmlPersistence p = new OncodriveAnalysisXmlPersistence();
        p.setRecursivePersistence(true);
        p.write(file, analysis, monitor);
    }
}

