/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.htest.enrichment;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.htest.HtestCommand;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.analysis.htest.enrichment.EnrichmentProcessor;
import org.gitools.datafilters.ValueTranslator;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.xml.EnrichmentAnalysisXmlPersistence;

public class EnrichmentCommand
extends HtestCommand {
    protected String modulesMime;
    protected String modulesPath;

    public EnrichmentCommand(EnrichmentAnalysis analysis, String dataMime, String dataFile, String populationPath, Double populationDefaultValue, String modulesMime, String modulesFile, String workdir, String fileName) {
        super(analysis, dataMime, dataFile, populationPath, populationDefaultValue, workdir, fileName);
        this.modulesMime = modulesMime;
        this.modulesPath = modulesFile;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        try {
            EnrichmentAnalysis enrichAnalysis = (EnrichmentAnalysis)this.analysis;
            monitor.begin("Loading ...", 1);
            monitor.info("Data: " + this.dataPath);
            monitor.info("Modules: " + this.modulesPath);
            this.loadDataAndModules(this.dataMime, this.dataPath, this.populationPath, this.modulesMime, this.modulesPath, enrichAnalysis, monitor.subtask());
            monitor.end();
            EnrichmentProcessor processor = new EnrichmentProcessor(enrichAnalysis);
            processor.run(monitor);
            this.save(enrichAnalysis, monitor);
        }
        catch (Throwable ex) {
            throw new AnalysisException(ex);
        }
    }

    private void save(EnrichmentAnalysis analysis, IProgressMonitor monitor) throws PersistenceException {
        File workdirFile = new File(this.workdir);
        if (!workdirFile.exists()) {
            workdirFile.mkdirs();
        }
        File file = new File(workdirFile, this.fileName);
        EnrichmentAnalysisXmlPersistence p = new EnrichmentAnalysisXmlPersistence();
        p.setRecursivePersistence(true);
        p.write(file, analysis, monitor);
    }

    private void loadDataAndModules(String dataFileMime, String dataFileName, String populationFileName, String modulesFileMime, String modulesFileName, EnrichmentAnalysis analysis, IProgressMonitor monitor) throws PersistenceException {
        String[] populationLabels = null;
        if (populationFileName != null) {
            File bgFile = new File(populationFileName);
            List popLabels = (List)PersistenceManager.getDefault().load(bgFile, "application/gitools-grp", monitor);
            populationLabels = popLabels.toArray(new String[popLabels.size()]);
        }
        File dataFile = new File(dataFileName);
        ValueTranslator valueTranslator = this.createValueTranslator(analysis.isBinaryCutoffEnabled(), analysis.getBinaryCutoffCmp(), analysis.getBinaryCutoffValue());
        Properties dataProps = new Properties();
        dataProps.put("binary_values", (Object)analysis.isBinaryCutoffEnabled());
        dataProps.put("value_translator", valueTranslator);
        if (populationLabels != null) {
            dataProps.put("population_labels", populationLabels);
            dataProps.put("background_value", this.populationDefaultValue);
        }
        BaseMatrix dataMatrix = this.loadDataMatrix(dataFile, dataFileMime, dataProps, monitor);
        PersistenceManager.getDefault().clearEntityCache(dataMatrix);
        File file = new File(modulesFileName);
        Properties modProps = new Properties();
        modProps.put("item_names_filter_enabled", (Object)true);
        modProps.put("item_names", dataMatrix.getRowStrings());
        modProps.put("min_size", (Object)analysis.getMinModuleSize());
        modProps.put("max_size", (Object)analysis.getMaxModuleSize());
        ModuleMap moduleMap = this.loadModuleMap(file, modulesFileMime, modProps, monitor);
        PersistenceManager.getDefault().clearEntityCache(moduleMap);
        if (analysis.isDiscardNonMappedRows()) {
            BaseMatrix fmatrix = null;
            try {
                fmatrix = (BaseMatrix)dataMatrix.getClass().newInstance();
            }
            catch (Exception ex) {
                throw new PersistenceException("Error filtering data matrix.", ex);
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            String[] names = moduleMap.getItemNames();
            HashSet<String> backgroundNames = new HashSet<String>();
            backgroundNames.addAll(Arrays.asList(names));
            for (int i = 0; i < dataMatrix.getRowCount(); ++i) {
                if (!backgroundNames.contains(dataMatrix.getRowLabel(i))) continue;
                rows.add(i);
            }
            int numRows = rows.size();
            int numColumns = dataMatrix.getColumnCount();
            fmatrix.make(numRows, numColumns);
            fmatrix.setColumns(dataMatrix.getColumns());
            for (int ri = 0; ri < numRows; ++ri) {
                int srcRow = (Integer)rows.get(ri);
                fmatrix.setRow(ri, dataMatrix.getRowLabel(srcRow));
                for (int ci = 0; ci < numColumns; ++ci) {
                    Object value = dataMatrix.getCellValue(srcRow, ci, 0);
                    fmatrix.setCellValue(ri, ci, 0, value);
                }
            }
            dataMatrix = fmatrix;
        }
        analysis.setData(dataMatrix);
        analysis.setModuleMap(moduleMap);
    }
}

