/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.groupcomparison;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.groupcomparison.GroupComparisonAnalysis;
import org.gitools.analysis.groupcomparison.GroupComparisonResult;
import org.gitools.analysis.htest.HtestProcessor;
import org.gitools.datafilters.BinaryCutoff;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.BeanElementAdapter;
import org.gitools.stats.mtc.MTC;
import org.gitools.stats.test.MannWhitneyWilxoxonTest;

public class GroupComparisonProcessor
extends HtestProcessor {
    private GroupComparisonAnalysis analysis;

    public GroupComparisonProcessor(GroupComparisonAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        Date startTime = new Date();
        IMatrix data = this.analysis.getData();
        if (this.analysis.isTransposeData()) {
            data = new TransposedMatrixView(data);
        }
        int numRows = data.getRowCount();
        ObjectMatrix resultsMatrix = new ObjectMatrix();
        String[] columnLabels = new String[]{this.analysis.getTest().getName()};
        String[] rlabels = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            rlabels[i] = data.getRowLabel(i);
        }
        resultsMatrix.setColumns(columnLabels);
        resultsMatrix.setRows(rlabels);
        resultsMatrix.makeCells();
        resultsMatrix.setCellAdapter(new BeanElementAdapter(GroupComparisonResult.class));
        monitor.begin("Running group comparison analysis ...", numRows);
        int attrIndex = this.analysis.getAttributeIndex();
        Class<?> valueClass = data.getCellAttributes().get(attrIndex).getValueClass();
        MatrixUtils.DoubleCast cast = MatrixUtils.createDoubleCast(valueClass);
        for (int column = 0; column < columnLabels.length; ++column) {
            for (int row = 0; row < numRows; ++row) {
                Double v;
                Object value;
                int gi;
                int[] group1 = this.getColumnIndices(data, this.analysis.getGroups1(), row);
                int[] group2 = this.getColumnIndices(data, this.analysis.getGroups2(), row);
                double[] groupVals1 = new double[group1.length];
                double[] groupVals2 = new double[group2.length];
                for (gi = 0; gi < group1.length; ++gi) {
                    value = data.getCellValue(row, group1[gi], attrIndex);
                    v = cast.getDoubleValue(value);
                    if (v == null || Double.isNaN(v)) {
                        v = Double.NaN;
                    }
                    groupVals1[gi] = v;
                }
                for (gi = 0; gi < group2.length; ++gi) {
                    value = data.getCellValue(row, group2[gi], attrIndex);
                    v = cast.getDoubleValue(value);
                    if (v == null || Double.isNaN(v)) {
                        v = Double.NaN;
                    }
                    groupVals2[gi] = v;
                }
                MannWhitneyWilxoxonTest test = (MannWhitneyWilxoxonTest)this.analysis.getTest();
                GroupComparisonResult r = test.processTest(groupVals1, groupVals2);
                resultsMatrix.setCell(row, column, r);
                monitor.worked(1);
            }
        }
        this.analysis.setResults(resultsMatrix);
        this.analysis.setStartTime(startTime);
        this.analysis.setElapsedTime(new Date().getTime() - startTime.getTime());
        MTC mtc = this.analysis.getMtc();
        this.multipleTestCorrection(resultsMatrix, mtc, monitor.subtask());
        this.analysis.setStartTime(startTime);
        this.analysis.setElapsedTime(new Date().getTime() - startTime.getTime());
        this.analysis.setResults(resultsMatrix);
        monitor.end();
    }

    private int[] getColumnIndices(IMatrix data, GroupComparisonAnalysis.ColumnGroup group, int row) {
        if (group.getColumns().length > 0) {
            return group.getColumns();
        }
        int attrIndex = group.getCutoffAttributeIndex();
        Class<?> valueClass = data.getCellAttributes().get(attrIndex).getValueClass();
        MatrixUtils.DoubleCast cast = MatrixUtils.createDoubleCast(valueClass);
        BinaryCutoff binaryCutoff = group.getBinaryCutoff();
        ArrayList<Integer> columnIndicesList = new ArrayList<Integer>();
        for (int col = 0; col < data.getColumnCount(); ++col) {
            double compliesCutoff;
            Object value = data.getCellValue(row, col, attrIndex);
            Double v = cast.getDoubleValue(value);
            if (v == null || Double.isNaN(v) || (compliesCutoff = binaryCutoff.apply(v)) != 1.0) continue;
            columnIndicesList.add(col);
        }
        Integer[] columnIndices = new Integer[columnIndicesList.size()];
        return ArrayUtils.toPrimitive((Integer[])columnIndicesList.toArray(columnIndices));
    }
}

