/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.correlation.methods;

import java.util.Properties;
import org.gitools.analysis.AbstractMethod;
import org.gitools.analysis.MethodException;
import org.gitools.analysis.correlation.CorrelationMethod;
import org.gitools.analysis.correlation.CorrelationResult;

public class PearsonCorrelationMethod
extends AbstractMethod
implements CorrelationMethod {
    public static final String ID = "pearson";

    public PearsonCorrelationMethod() {
        this(new Properties());
    }

    public PearsonCorrelationMethod(Properties properties) {
        super(ID, "Pearson's correlation", "Pearson's product-moment correlation", CorrelationResult.class, properties);
    }

    @Override
    public CorrelationResult correlation(double[] x, double[] y, int[] indices, int indicesLength) throws MethodException {
        CorrelationResult result = new CorrelationResult();
        double sumxy = 0.0;
        double sumx = 0.0;
        double sumx2 = 0.0;
        double sumy = 0.0;
        double sumy2 = 0.0;
        double n = indicesLength;
        for (int k = 0; k < indicesLength; ++k) {
            int i = indices[k];
            double xi = x[i];
            double yi = y[i];
            sumxy += xi * yi;
            sumx += xi;
            sumx2 += xi * xi;
            sumy += yi;
            sumy2 += yi * yi;
        }
        double r = (sumxy - sumx * sumy / n) / Math.sqrt((sumx2 - sumx * sumx / n) * (sumy2 - sumy * sumy / n));
        double se = Math.sqrt((1.0 - r * r) / (n - 2.0));
        result.setN(indicesLength);
        result.setScore(r);
        result.setStandardError(se);
        return result;
    }
}

