/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.correlation;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.Properties;
import org.gitools.analysis.AnalysisCommand;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.correlation.CorrelationAnalysis;
import org.gitools.analysis.correlation.CorrelationProcessor;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.persistence.PersistenceManager;

public class CorrelationCommand
extends AnalysisCommand {
    protected CorrelationAnalysis analysis;
    protected String dataMime;
    protected String dataPath;

    public CorrelationCommand(CorrelationAnalysis analysis, String dataMime, String dataPath, String workdir, String fileName) {
        super(workdir, fileName);
        this.analysis = analysis;
        this.dataMime = dataMime;
        this.dataPath = dataPath;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        try {
            BaseMatrix data = this.loadDataMatrix(new File(this.dataPath), this.dataMime, new Properties(), monitor);
            this.analysis.setData(data);
            CorrelationProcessor proc = new CorrelationProcessor(this.analysis);
            proc.run(monitor);
            File workdirFile = new File(this.workdir);
            if (!workdirFile.exists()) {
                workdirFile.mkdirs();
            }
            File file = new File(workdirFile, this.fileName);
            PersistenceManager.getDefault().store(file, this.analysis, monitor);
        }
        catch (Throwable cause) {
            throw new AnalysisException(cause);
        }
    }
}

