/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.combination;

import cern.jet.stat.Probability;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.Arrays;
import java.util.Date;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.AnalysisProcessor;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.analysis.combination.CombinationResult;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.BeanElementAdapter;
import org.gitools.model.ModuleMap;

public class CombinationProcessor
implements AnalysisProcessor {
    private CombinationAnalysis analysis;

    public CombinationProcessor(CombinationAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        Date startTime = new Date();
        IMatrix data = this.analysis.getData();
        if (this.analysis.isTransposeData()) {
            data = new TransposedMatrixView(data);
        }
        int numCols = data.getColumnCount();
        int numRows = data.getRowCount();
        String[] labels = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            labels[i] = data.getColumnLabel(i);
        }
        String combOf = this.analysis.isTransposeData() ? "rows" : "columns";
        ModuleMap cmap = this.analysis.getGroupsMap();
        cmap = cmap != null ? cmap.remap(labels) : new ModuleMap("All data " + combOf, labels);
        this.analysis.setGroupsMap(cmap);
        ObjectMatrix results = new ObjectMatrix();
        String[] cclabels = cmap.getModuleNames();
        cclabels = Arrays.copyOf(cclabels, cclabels.length);
        String[] rlabels = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            rlabels[i] = data.getRowLabel(i);
        }
        results.setColumns(cclabels);
        results.setRows(rlabels);
        results.makeCells();
        results.setCellAdapter(new BeanElementAdapter(CombinationResult.class));
        this.analysis.setResults(results);
        int sizeIndex = -1;
        String sizeAttrName = this.analysis.getSizeAttrName();
        if (sizeAttrName != null && !sizeAttrName.isEmpty()) {
            sizeIndex = data.getCellAdapter().getPropertyIndex(sizeAttrName);
        }
        int pvalueIndex = 0;
        String pvalueAttrName = this.analysis.getPvalueAttrName();
        if (pvalueAttrName != null && !pvalueAttrName.isEmpty()) {
            pvalueIndex = data.getCellAdapter().getPropertyIndex(pvalueAttrName);
        }
        MatrixUtils.DoubleCast sizeCast = null;
        if (sizeIndex >= 0) {
            sizeCast = MatrixUtils.createDoubleCast(data.getCellAdapter().getProperty(sizeIndex).getValueClass());
        }
        MatrixUtils.DoubleCast pvalueCast = MatrixUtils.createDoubleCast(data.getCellAdapter().getProperty(pvalueIndex).getValueClass());
        int numCC = cmap.getModuleCount();
        monitor.begin("Running combination analysis ...", numCC * numRows);
        for (int cmi = 0; cmi < numCC; ++cmi) {
            int[] cindices = cmap.getItemIndices(cmi);
            for (int ri = 0; ri < numRows; ++ri) {
                int n = 0;
                double sumSizeZ = 0.0;
                double sumSizeSqr = 0.0;
                for (int ci = 0; ci < cindices.length; ++ci) {
                    double zscore;
                    double pvalue;
                    double size;
                    int mci = cindices[ci];
                    if (data.getCell(ri, mci) == null || Double.isNaN((size = sizeIndex < 0 ? 1.0 : sizeCast.getDoubleValue(data.getCellValue(ri, mci, sizeIndex))) + (pvalue = pvalueCast.getDoubleValue(data.getCellValue(ri, mci, pvalueIndex)).doubleValue()) + (zscore = this.pvalueToZscore(pvalue)))) continue;
                    ++n;
                    sumSizeZ += size * zscore;
                    sumSizeSqr += size * size;
                }
                double zcomb = sumSizeZ / Math.sqrt(sumSizeSqr);
                double pvalue = this.zscoreToPvalue(zcomb);
                CombinationResult r = new CombinationResult();
                r.setN(n);
                r.setZscore(zcomb);
                r.setPvalue(pvalue);
                results.setCell(ri, cmi, r);
                monitor.worked(1);
            }
        }
        this.analysis.setStartTime(startTime);
        this.analysis.setElapsedTime(new Date().getTime() - startTime.getTime());
        monitor.end();
    }

    private double pvalueToZscore(double pvalue) {
        if (Double.isNaN(pvalue)) {
            return pvalue;
        }
        pvalue = (pvalue = 1.0 - pvalue) < 1.0E-6 ? 1.0E-6 : pvalue;
        pvalue = pvalue > 0.999999 ? 0.999999 : pvalue;
        double zscore = Probability.normalInverse((double)pvalue);
        return zscore;
    }

    private double zscoreToPvalue(double zscore) {
        if (Double.isNaN(zscore)) {
            return zscore;
        }
        double pvalue = 1.0 - Probability.normal((double)zscore);
        return pvalue;
    }
}

