/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.combination;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.Properties;
import org.gitools.analysis.AnalysisCommand;
import org.gitools.analysis.AnalysisException;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.analysis.combination.CombinationProcessor;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceManager;

public class CombinationCommand
extends AnalysisCommand {
    protected CombinationAnalysis analysis;
    protected String dataMime;
    protected String dataPath;
    protected String columnsMime;
    protected String columnsPath;

    public CombinationCommand(CombinationAnalysis analysis, String dataMime, String dataPath, String columnsMime, String columnsPath, String workdir, String fileName) {
        super(workdir, fileName);
        this.analysis = analysis;
        this.dataMime = dataMime;
        this.dataPath = dataPath;
        this.columnsMime = columnsMime;
        this.columnsPath = columnsPath;
        this.storeAnalysis = true;
    }

    @Override
    public void run(IProgressMonitor monitor) throws AnalysisException {
        try {
            if (this.analysis.getData() == null) {
                BaseMatrix data = this.loadDataMatrix(new File(this.dataPath), this.dataMime, new Properties(), monitor);
                this.analysis.setData(data);
            }
            if (this.columnsPath != null) {
                ModuleMap columnsMap = this.loadModuleMap(new File(this.columnsPath), this.columnsMime, new Properties(), monitor);
                this.analysis.setGroupsMap(columnsMap);
            }
            CombinationProcessor proc = new CombinationProcessor(this.analysis);
            proc.run(monitor);
            if (this.storeAnalysis) {
                File workdirFile = new File(this.workdir);
                if (!workdirFile.exists()) {
                    workdirFile.mkdirs();
                }
                File file = new File(workdirFile, this.fileName);
                PersistenceManager.getDefault().store(file, this.analysis, monitor);
            }
        }
        catch (Throwable cause) {
            throw new AnalysisException(cause);
        }
    }
}

