/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.Properties;
import org.gitools.analysis.AnalysisException;
import org.gitools.datafilters.BinaryCutoff;
import org.gitools.datafilters.BinaryCutoffTranslator;
import org.gitools.datafilters.DoubleTranslator;
import org.gitools.datafilters.ValueTranslator;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;

public abstract class AnalysisCommand {
    protected String workdir;
    protected String fileName;
    protected boolean storeAnalysis;

    public AnalysisCommand(String workdir, String fileName) {
        this.workdir = workdir;
        this.fileName = fileName;
        this.storeAnalysis = true;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public void setWorkdir(String workdir) {
        this.workdir = workdir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isStoreAnalysis() {
        return this.storeAnalysis;
    }

    public void setStoreAnalysis(boolean storeAnalysis) {
        this.storeAnalysis = storeAnalysis;
    }

    public abstract void run(IProgressMonitor var1) throws AnalysisException;

    protected BaseMatrix loadDataMatrix(File file, String mime, Properties props, IProgressMonitor monitor) throws PersistenceException {
        Object obj = PersistenceManager.getDefault().load(file, mime, props, monitor);
        BaseMatrix matrix = null;
        if (obj instanceof BaseMatrix) {
            matrix = (BaseMatrix)obj;
        } else if (obj instanceof ModuleMap) {
            matrix = MatrixUtils.moduleMapToMatrix((ModuleMap)obj);
        } else {
            throw new PersistenceException("Invalid MIME type for data: " + mime);
        }
        return matrix;
    }

    protected ModuleMap loadModuleMap(File file, String mime, Properties props, IProgressMonitor monitor) throws PersistenceException {
        Object obj = PersistenceManager.getDefault().load(file, mime, props, monitor);
        ModuleMap moduleMap = null;
        if (obj instanceof BaseMatrix) {
            moduleMap = MatrixUtils.matrixToModuleMap((BaseMatrix)obj);
        } else if (obj instanceof ModuleMap) {
            moduleMap = (ModuleMap)obj;
        } else {
            throw new PersistenceException("Invalid MIME type for modules: " + mime);
        }
        return moduleMap;
    }

    protected ValueTranslator createValueTranslator(boolean binaryCutoffEnabled, CutoffCmp cutoffCmp, Double cutoffValue) {
        return binaryCutoffEnabled ? new BinaryCutoffTranslator(new BinaryCutoff(cutoffCmp, cutoffValue)) : new DoubleTranslator();
    }
}

