/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.aggregation;

import cern.jet.math.Functions;
import org.gitools.aggregation.AbstractAggregator;

public class SumAbsAggregator
extends AbstractAggregator {
    @Override
    public double aggregate(double[] data) {
        int nanValue = 0;
        if (data.length == 1) {
            return this.checkNaN(data[0], nanValue);
        }
        return this.aggregate(data, Functions.plusAbs, nanValue);
    }

    public String toString() {
        return "Absolute Sum";
    }

    private double checkNaN(double d, int nanValue) {
        return Double.isNaN(d) ? (double)nanValue : Math.abs(d);
    }
}

