/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gitools.aggregation.IAggregator;
import org.gitools.aggregation.LogSumAggregator;
import org.gitools.aggregation.MeanAggregator;
import org.gitools.aggregation.MultAggregator;
import org.gitools.aggregation.SumAbsAggregator;
import org.gitools.aggregation.SumAggregator;

public class AggregatorFactory {
    private static final List<IAggregator> aggregators = new ArrayList<IAggregator>();
    private static final Map<String, IAggregator> aggregatorsMap = new HashMap<String, IAggregator>();

    private static void put(IAggregator aggregator) {
        aggregators.add(aggregator);
        aggregatorsMap.put(aggregator.toString(), aggregator);
    }

    public static IAggregator create(String name) {
        return aggregatorsMap.get(name);
    }

    public static Collection<IAggregator> getAggregators() {
        return Collections.unmodifiableCollection(aggregators);
    }

    public static IAggregator[] getAggregatorsArray() {
        IAggregator[] aggregatorsArray = new IAggregator[aggregators.size()];
        aggregators.toArray(aggregatorsArray);
        return aggregatorsArray;
    }

    static {
        AggregatorFactory.put(new MultAggregator());
        AggregatorFactory.put(new SumAggregator());
        AggregatorFactory.put(new MeanAggregator());
        AggregatorFactory.put(new LogSumAggregator());
        AggregatorFactory.put(new SumAbsAggregator());
    }
}

