/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.aggregation;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import org.gitools.aggregation.IAggregator;

public abstract class AbstractAggregator
implements IAggregator {
    protected double aggregate(double[] data, DoubleDoubleFunction reduceFunc, DoubleFunction mapFunc, double nanValue) {
        if (data.length == 0) {
            return 0.0;
        }
        if (data.length == 1) {
            return mapFunc.apply(this.checkNaN(data[0], nanValue));
        }
        double value = reduceFunc.apply(mapFunc.apply(this.checkNaN(data[0], nanValue)), mapFunc.apply(this.checkNaN(data[1], nanValue)));
        for (int i = 2; i < data.length; ++i) {
            value = reduceFunc.apply(value, mapFunc.apply(this.checkNaN(data[i], nanValue)));
        }
        return value;
    }

    protected double aggregate(double[] data, DoubleDoubleFunction reduceFunc, double nanValue) {
        if (data.length == 0) {
            return 0.0;
        }
        if (data.length == 1) {
            return this.checkNaN(data[0], nanValue);
        }
        double value = reduceFunc.apply(this.checkNaN(data[0], nanValue), this.checkNaN(data[1], nanValue));
        for (int i = 2; i < data.length; ++i) {
            value = reduceFunc.apply(value, this.checkNaN(data[i], nanValue));
        }
        return value;
    }

    private double checkNaN(double d, double nanValue) {
        return Double.isNaN(d) ? nanValue : d;
    }
}

