/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.htest;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import edu.upf.bg.progressmonitor.StreamProgressMonitor;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import org.gitools.analysis.htest.HtestAnalysis;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.analysis.htest.oncozet.OncodriveCommand;
import org.gitools.cli.htest.HtestTool;
import org.gitools.stats.test.factory.TestFactory;
import org.gitools.threads.ThreadManager;
import org.kohsuke.args4j.Option;

public class OncodriveTool
extends HtestTool {
    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        OncodriveArguments args = (OncodriveArguments)argsObject;
        this.testConfig = TestFactory.createToolConfig((String)"oncodrive", (String)args.testName);
        if (this.testConfig == null) {
            throw new ToolValidationException("Unknown test: " + args.testName);
        }
        if (args.minSetSize < 1) {
            args.minSetSize = 1;
        }
        if (args.maxSetSize < args.minSetSize) {
            args.maxSetSize = args.minSetSize;
        }
    }

    @Override
    public void run(Object argsObject) throws ToolException {
        OncodriveArguments args = (OncodriveArguments)argsObject;
        OncodriveAnalysis analysis = new OncodriveAnalysis();
        this.prepareAnalysis((HtestAnalysis)analysis, args);
        analysis.setMinModuleSize(args.minSetSize);
        analysis.setMaxModuleSize(args.maxSetSize);
        String dataMime = this.mimeFromFormat(args.dataMime, args.dataFile, "application/gitools-matrix-double");
        String setsMime = this.mimeFromFormat(args.setsMime, args.setsFile, "application/gitools-modules-2c");
        OncodriveCommand cmd = new OncodriveCommand(analysis, dataMime, args.dataFile, args.populationFile, this.populationDefaultValue, setsMime, args.setsFile, args.workdir, args.analysisName + "." + "oncodrive");
        IProgressMonitor monitor = !args.quiet ? new StreamProgressMonitor(System.out, args.verbose, args.debug) : new NullProgressMonitor();
        ThreadManager.setNumThreads((int)args.maxProcs);
        try {
            cmd.run(monitor);
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        finally {
            ThreadManager.shutdown((IProgressMonitor)monitor);
        }
    }

    public static class OncodriveArguments
    extends HtestTool.HtestArguments {
        @Option(name="-sf", aliases={"-sets-format"}, metaVar="<format>", usage="Column sets file format (MIME type or file extension).")
        public String setsMime;
        @Option(name="-s", aliases={"-sets"}, metaVar="<file>", usage="File with mappings for column sets.")
        public String setsFile;
        @Option(name="-min", aliases={"-min-set-size"}, metaVar="<min>", usage="Discard all column sets that have\nless columns than <min> (default: 20)")
        private int minSetSize = 20;
        @Option(name="-max", aliases={"-max-set-size"}, metaVar="<max>", usage="Discard all column sets that have\nmore columns than <max> (default: no limit)")
        private int maxSetSize = Integer.MAX_VALUE;
    }
}

