/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.htest;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gitools.analysis.htest.HtestAnalysis;
import org.gitools.cli.AnalysisArguments;
import org.gitools.cli.AnalysisTool;
import org.gitools.model.Analysis;
import org.gitools.model.ToolConfig;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public abstract class HtestTool
extends AnalysisTool {
    protected boolean binaryCutoffEnabled = false;
    protected CutoffCmp binaryCutoffCmp;
    protected double binaryCutoffValue;
    protected Double populationDefaultValue;
    protected ToolConfig testConfig;
    protected List<String[]> testConfigParams = new ArrayList<String[]>(0);

    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        HtestArguments args = (HtestArguments)argsObject;
        if (args.testName == null) {
            throw new ToolValidationException("Test name has to be specified.");
        }
        for (String conf : args.testConf) {
            String[] c = conf.split("=", 2);
            if (c.length != 2) {
                throw new ToolValidationException("Malformed test configuration parameter: " + conf);
            }
            this.testConfigParams.add(c);
        }
        if (args.dataFile == null) {
            throw new ToolValidationException("Data file has to be specified.");
        }
        if (args.binCutoff != null) {
            Pattern pat = Pattern.compile("^(lt|le|eq|gt|ge|alt|ale|aeq|agt|age)\\,(.+)$");
            args.binCutoff = args.binCutoff.toLowerCase();
            Matcher mat = pat.matcher(args.binCutoff);
            if (!mat.matches()) {
                throw new ToolValidationException("Invalid parameters for binary cutoff filter: " + args.binCutoff);
            }
            try {
                this.binaryCutoffEnabled = true;
                this.binaryCutoffCmp = CutoffCmp.getFromName(mat.group(1));
                this.binaryCutoffValue = Double.parseDouble(mat.group(2));
            }
            catch (NumberFormatException e) {
                throw new ToolValidationException("Invalid cutoff: " + mat.group(2));
            }
        }
        if (args.populationDefaultValue.equalsIgnoreCase("empty")) {
            this.populationDefaultValue = null;
        } else if (args.populationDefaultValue.equalsIgnoreCase("nan")) {
            this.populationDefaultValue = Double.NaN;
        } else {
            try {
                this.populationDefaultValue = Double.parseDouble(args.populationDefaultValue);
            }
            catch (NumberFormatException ex) {
                throw new ToolValidationException("Population default value should be a number, 'empty' or 'nan");
            }
        }
    }

    protected void prepareAnalysis(HtestAnalysis analysis, HtestArguments args) {
        this.prepareGeneralAnalysisAttributes((Analysis)analysis, args);
        analysis.setBinaryCutoffEnabled(this.binaryCutoffEnabled);
        analysis.setBinaryCutoffCmp(this.binaryCutoffCmp);
        analysis.setBinaryCutoffValue(this.binaryCutoffValue);
        for (String[] c : this.testConfigParams) {
            this.testConfig.put(c[0], c[1]);
        }
        analysis.setTestConfig(this.testConfig);
        analysis.setMtc(args.mtc);
    }

    @Override
    public void printUsage(PrintStream outputStream, String appName, ToolDescriptor toolDesc, CmdLineParser parser) {
        super.printUsage(outputStream, appName, toolDesc, parser);
        outputStream.println();
        this.printTests(outputStream);
        outputStream.println();
        this.printDataFormats(outputStream);
        outputStream.println();
        this.printModulesFormats(outputStream);
        outputStream.println();
    }

    private void printTests(PrintStream o) {
        o.println("Available tests:");
        o.println(String.format("\t* %-16s%s", "zscore", "Z-score test"));
        o.println(String.format("\t* %-16s%s", "binomial", "Binomial test"));
        o.println(String.format("\t* %-16s%s", "fisher", "Fisher's exact test"));
    }

    public static class HtestArguments
    extends AnalysisArguments {
        @Option(name="-t", aliases={"-test"}, metaVar="<name>", usage="Statistical test to use.")
        public String testName;
        @Option(name="-tc", aliases={"-test-conf"}, metaVar="<param=value>", usage="Define a test configuration parameter. This allows to configure the behaviour of the test.")
        public List<String> testConf = new ArrayList<String>(0);
        @Option(name="-mtc", metaVar="<name>", usage="Multiple test correxction method.\nAvailable: bonferroni, bh. (default: bh)")
        public String mtc = "bh";
        @Option(name="-df", aliases={"-data-format"}, metaVar="<format>", usage="Data file format (MIME type or file extension).")
        public String dataMime;
        @Option(name="-d", aliases={"-data"}, metaVar="<file>", usage="File with data to be processed.")
        public String dataFile;
        @Option(name="-P", aliases={"-population"}, metaVar="<file>", usage="File with background population elements.")
        public String populationFile;
        @Option(name="-Pv", aliases={"-population-default-value"}, metaVar="<value>", usage="Default value to use when a population element\ndoesn't exist in the data.\nIt can be a number, 'empty' or 'nan'. (default: 0)")
        public String populationDefaultValue = "0.0";
        @Option(name="-b", aliases={"-bin-cutoff-filt"}, usage="Binary cutoff filter. Available conditions:\nlt (less than), le (less equal than),\neq (equal), ne (not equal),\ngt (greatar than), ge (greater equal than),alt (abs less than), ale (abs less equal than),\naeq (abs equal), ane (abs not equal),\nagt (abs greatar than), age (abs greater equal than)", metaVar="<CONDITION,CUTOFF>")
        public String binCutoff;
    }
}

