/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.htest;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import edu.upf.bg.progressmonitor.StreamProgressMonitor;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import org.gitools.analysis.htest.HtestAnalysis;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.analysis.htest.enrichment.EnrichmentCommand;
import org.gitools.cli.htest.HtestTool;
import org.gitools.stats.test.factory.TestFactory;
import org.gitools.threads.ThreadManager;
import org.kohsuke.args4j.Option;

public class EnrichmentTool
extends HtestTool {
    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        EnrichmentArguments args = (EnrichmentArguments)argsObject;
        this.testConfig = TestFactory.createToolConfig((String)"enrichment", (String)args.testName);
        if (this.testConfig == null) {
            throw new ToolValidationException("Unknown test: " + args.testName);
        }
        if (args.modulesFile == null) {
            throw new ToolValidationException("Groups file has to be specified.");
        }
        if (args.minModuleSize < 1) {
            args.minModuleSize = 1;
        }
        if (args.maxModuleSize < args.minModuleSize) {
            args.maxModuleSize = args.minModuleSize;
        }
    }

    @Override
    public void run(Object argsObject) throws ToolException {
        EnrichmentArguments args = (EnrichmentArguments)argsObject;
        EnrichmentAnalysis analysis = new EnrichmentAnalysis();
        this.prepareAnalysis((HtestAnalysis)analysis, args);
        analysis.setMinModuleSize(args.minModuleSize);
        analysis.setMaxModuleSize(args.maxModuleSize);
        analysis.setDiscardNonMappedRows(args.discardNonMappedRows);
        String dataMime = this.mimeFromFormat(args.dataMime, args.dataFile, "application/gitools-matrix-double");
        String modulesMime = this.mimeFromFormat(args.modulesMime, args.modulesFile, "application/gitools-modules-2c");
        EnrichmentCommand cmd = new EnrichmentCommand(analysis, dataMime, args.dataFile, args.populationFile, this.populationDefaultValue, modulesMime, args.modulesFile, args.workdir, args.analysisName + "." + "enrichment");
        IProgressMonitor monitor = !args.quiet ? new StreamProgressMonitor(System.out, args.verbose, args.debug) : new NullProgressMonitor();
        ThreadManager.setNumThreads((int)args.maxProcs);
        try {
            cmd.run(monitor);
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        finally {
            ThreadManager.shutdown((IProgressMonitor)monitor);
        }
    }

    public static class EnrichmentArguments
    extends HtestTool.HtestArguments {
        @Option(name="-mf", aliases={"-modules-format"}, metaVar="<format>", usage="Modules file format (MIME type or file extension).")
        public String modulesMime;
        @Option(name="-m", aliases={"-modules"}, metaVar="<file>", usage="File with mappings between items and modules.")
        public String modulesFile;
        @Option(name="-min", aliases={"-min-mod-size"}, metaVar="<min>", usage="Discard all modules that have\nless items than <min> (default: 20)")
        private int minModuleSize = 20;
        @Option(name="-max", aliases={"-max-mod-size"}, metaVar="<max>", usage="Discard all modules that have\nmore items than <max> (default: no limit)")
        private int maxModuleSize = Integer.MAX_VALUE;
        @Option(name="-omi", aliases={"-only-mapped-items"}, usage="Consider only items having a mapping for the background.\n(default: all items in data file will be considered)")
        private boolean discardNonMappedRows = false;
    }
}

