/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.convert;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import org.gitools.cli.convert.ConversionDelegate;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.matrix.model.DoubleBinaryMatrix;
import org.gitools.matrix.model.DoubleMatrix;

public class MatrixConversion
implements ConversionDelegate {
    @Override
    public Object convert(String srcMime, Object src, String dstMime, IProgressMonitor monitor) throws Exception {
        BaseMatrix srcMatrix = (BaseMatrix)src;
        BaseMatrix dstMatrix = null;
        Class<DoubleMatrix> cls = null;
        if ("application/gitools-matrix-double".equals(dstMime)) {
            cls = DoubleMatrix.class;
        } else if ("application/gitools-matrix-binary".equals(dstMime) || "application/gitools-gmx".equals(dstMime) || "application/gitools-gmt".equals(dstMime)) {
            cls = DoubleBinaryMatrix.class;
        } else {
            throw new Exception("Unsupported mime type for destination matrix: " + dstMime);
        }
        int numCols = srcMatrix.getColumnCount();
        int numRows = srcMatrix.getRowCount();
        monitor.begin("Converting matrix ...", numRows);
        if (!cls.equals(src.getClass())) {
            dstMatrix = (BaseMatrix)cls.newInstance();
            dstMatrix.makeCells(numRows, numCols);
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < numCols; ++col) {
                    Object value = srcMatrix.getCellValue(row, col, 0);
                    dstMatrix.setCellValue(row, col, 0, value);
                }
                monitor.worked(1);
            }
            dstMatrix.setColumns(srcMatrix.getColumns());
            dstMatrix.setRows(srcMatrix.getRows());
        } else {
            dstMatrix = srcMatrix;
        }
        monitor.end();
        return dstMatrix;
    }
}

