/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.convert;

import edu.upf.bg.progressmonitor.StreamProgressMonitor;
import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import edu.upf.bg.tools.impl.AbstractTool;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.gitools.cli.GitoolsArguments;
import org.gitools.cli.convert.Conversion;
import org.gitools.cli.convert.MatrixConversion;
import org.gitools.cli.convert.MatrixToModulesConversion;
import org.gitools.cli.convert.ModulesConversion;
import org.gitools.cli.convert.ModulesToMatrixConversion;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ConvertTool
extends AbstractTool {
    protected static final String LIST_L_FMT = "\t* %-48s%s";

    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        Arguments args = (Arguments)argsObject;
        if (args.inputFileName == null) {
            throw new ToolValidationException("An input file is required.");
        }
        if (args.inputFileFormat == null) {
            args.inputFileFormat = PersistenceManager.getDefault().getMimeFromFile(args.inputFileName);
            if (args.inputFileFormat == null) {
                throw new ToolValidationException("Unknown input file format.\nYou can use the option -input-format");
            }
        }
        if (args.outputFileName == null) {
            throw new ToolValidationException("An output file is required.");
        }
        if (args.outputFileFormat == null) {
            args.outputFileFormat = PersistenceManager.getDefault().getMimeFromFile(args.outputFileName);
            if (args.outputFileFormat == null) {
                throw new ToolValidationException("Unknown output file format.\nYou can use the option -output-format");
            }
        }
    }

    @Override
    public void run(Object argsObject) throws ToolException {
        super.run(argsObject);
        Arguments args = (Arguments)argsObject;
        ArrayList<Conversion> vc = new ArrayList<Conversion>();
        this.initConversionList(vc);
        String inputMime = this.mimeFromFormat(args.inputFileFormat, args.inputFileName);
        String outputMime = this.mimeFromFormat(args.outputFileFormat, args.outputFileName);
        Conversion targetConv = new Conversion(inputMime, outputMime);
        int convIndex = vc.indexOf(targetConv);
        if (convIndex < 0) {
            throw new ToolException("Unsupportted conversion from '" + args.inputFileFormat + "' to '" + args.outputFileFormat + "'");
        }
        targetConv = (Conversion)vc.get(convIndex);
        if (targetConv.delegate == null) {
            throw new ToolException("Unimplemented conversion from '" + args.inputFileFormat + "' to '" + args.outputFileFormat + "'");
        }
        StreamProgressMonitor monitor = new StreamProgressMonitor(System.out, args.verbose, args.debug);
        monitor.begin("Loading input file ...", 1);
        File inputFile = new File(args.inputFileName);
        Object srcObject = null;
        try {
            srcObject = PersistenceManager.getDefault().load(inputFile, inputMime, monitor.subtask());
        }
        catch (PersistenceException ex) {
            monitor.exception(ex);
            throw new ToolException(ex);
        }
        if (srcObject == null) {
            throw new ToolException("Unexpected error loading " + args.inputFileName);
        }
        monitor.end();
        Object dstObject = null;
        try {
            dstObject = targetConv.delegate.convert(args.inputFileFormat, srcObject, args.outputFileFormat, monitor);
        }
        catch (Exception ex) {
            monitor.exception(ex);
            throw new ToolException(ex);
        }
        monitor.begin("Saving output file ...", 1);
        File outputFile = new File(args.outputFileName);
        try {
            PersistenceManager.getDefault().store(outputFile, outputMime, dstObject, monitor.subtask());
        }
        catch (PersistenceException ex) {
            monitor.exception(ex);
            throw new ToolException(ex);
        }
        monitor.end();
    }

    private void initConversionList(List<Conversion> vc) {
        vc.add(new Conversion("application/gitools-matrix-binary", "application/gitools-matrix-double", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-binary", "application/gitools-gmx", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-binary", "application/gitools-gmt", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-binary", "application/gitools-modules-2c", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-matrix-binary", "application/gitools-modules-indexed", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-matrix-double", "application/gitools-matrix-binary", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-double", "application/gitools-gmx", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-double", "application/gitools-gmt", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-matrix-double", "application/gitools-modules-2c", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-matrix-double", "application/gitools-modules-indexed", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-gmx", "application/gitools-matrix-binary", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-gmx", "application/gitools-matrix-double", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-gmx", "application/gitools-modules-2c", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-gmx", "application/gitools-modules-indexed", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-gmt", "application/gitools-matrix-binary", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-gmt", "application/gitools-matrix-double", new MatrixConversion()));
        vc.add(new Conversion("application/gitools-gmt", "application/gitools-modules-2c", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-gmt", "application/gitools-modules-indexed", new MatrixToModulesConversion()));
        vc.add(new Conversion("application/gitools-modules-2c", "application/gitools-modules-indexed", new ModulesConversion()));
        vc.add(new Conversion("application/gitools-modules-2c", "application/gitools-matrix-double", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-2c", "application/gitools-matrix-binary", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-2c", "application/gitools-gmx", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-2c", "application/gitools-gmt", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-indexed", "application/gitools-modules-2c", new ModulesConversion()));
        vc.add(new Conversion("application/gitools-modules-indexed", "application/gitools-matrix-double", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-indexed", "application/gitools-matrix-binary", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-indexed", "application/gitools-gmx", new ModulesToMatrixConversion()));
        vc.add(new Conversion("application/gitools-modules-indexed", "application/gitools-gmt", new ModulesToMatrixConversion()));
    }

    protected String mimeFromFormat(String format, String fileName) {
        String mime = null;
        if (fileName == null) {
            return null;
        }
        if (format != null) {
            mime = PersistenceManager.getDefault().getMimeFromFile("fake." + format);
            if (mime == null) {
                mime = format;
            }
        } else {
            mime = PersistenceManager.getDefault().getMimeFromFile(fileName);
        }
        return mime;
    }

    @Override
    public void printUsage(PrintStream outputStream, String appName, ToolDescriptor toolDesc, CmdLineParser parser) {
        FileFormat[] formats;
        super.printUsage(outputStream, appName, toolDesc, parser);
        outputStream.println();
        outputStream.println("Supported formats:");
        for (FileFormat f : formats = new FileFormat[]{FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.MODULES_2C_MAP}) {
            outputStream.println(String.format(LIST_L_FMT, f.getExtension() + " (" + f.getMime() + ")", f.getTitle()));
        }
    }

    public static class Arguments
    extends GitoolsArguments {
        @Option(name="-i", aliases={"-input"}, metaVar="<path>", usage="Input file.")
        public String inputFileName;
        @Option(name="-if", aliases={"-input-format"}, metaVar="<FORMAT>", usage="Input file format.")
        public String inputFileFormat;
        @Option(name="-o", aliases={"-output"}, metaVar="<path>", usage="Output file.")
        public String outputFileName;
        @Option(name="-of", aliases={"-output-format"}, metaVar="<FORMAT>", usage="Output file format.")
        public String outputFileFormat;
    }
}

