/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli.combination;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import edu.upf.bg.progressmonitor.StreamProgressMonitor;
import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import java.io.PrintStream;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.analysis.combination.CombinationCommand;
import org.gitools.cli.AnalysisArguments;
import org.gitools.cli.AnalysisTool;
import org.gitools.model.Analysis;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.threads.ThreadManager;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class CombinationTool
extends AnalysisTool {
    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        CombinationArguments args = (CombinationArguments)argsObject;
        if (args.dataFile == null) {
            throw new ToolValidationException("Data file should be specified.");
        }
    }

    @Override
    public void run(Object argsObject) throws ToolException {
        CombinationArguments args = (CombinationArguments)argsObject;
        CombinationAnalysis analysis = new CombinationAnalysis();
        this.prepareGeneralAnalysisAttributes((Analysis)analysis, args);
        analysis.setTransposeData(args.applyToRows);
        analysis.setSizeAttrName(args.sizeName);
        analysis.setPvalueAttrName(args.pvalueName);
        String dataMime = this.mimeFromFormat(args.dataMime, args.dataFile, "application/gitools-matrix-double");
        String columnsMime = this.mimeFromFormat(args.columnsMime, args.columnsFile, "application/gitools-modules-2c");
        CombinationCommand cmd = new CombinationCommand(analysis, dataMime, args.dataFile, columnsMime, args.columnsFile, args.workdir, args.analysisName + "." + "combination");
        IProgressMonitor monitor = !args.quiet ? new StreamProgressMonitor(System.out, args.verbose, args.debug) : new NullProgressMonitor();
        ThreadManager.setNumThreads((int)args.maxProcs);
        try {
            cmd.run(monitor);
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        finally {
            ThreadManager.shutdown((IProgressMonitor)monitor);
        }
    }

    @Override
    public void printUsage(PrintStream outputStream, String appName, ToolDescriptor toolDesc, CmdLineParser parser) {
        super.printUsage(outputStream, appName, toolDesc, parser);
        outputStream.println();
        this.printDataFormats(outputStream);
        outputStream.println();
        this.printModulesFormats(outputStream);
        outputStream.println();
    }

    @Override
    protected void printDataFormats(PrintStream out) {
        FileFormat[] formats;
        out.println("Supported data formats:");
        for (FileFormat f : formats = new FileFormat[]{FileFormats.RESULTS_MATRIX, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.MODULES_2C_MAP}) {
            out.println(String.format("\t* %-48s%s", f.getExtension() + " (" + f.getMime() + ")", f.getTitle()));
        }
    }

    public static class CombinationArguments
    extends AnalysisArguments {
        @Option(name="-df", aliases={"-data-format"}, metaVar="<format>", usage="Data file format (MIME type or file extension).")
        public String dataMime;
        @Option(name="-d", aliases={"-data"}, metaVar="<file>", usage="File with data to be processed.")
        public String dataFile;
        @Option(name="-cf", aliases={"-columns-format"}, metaVar="<format>", usage="Columns file format (MIME type or file extension).")
        public String columnsMime;
        @Option(name="-c", aliases={"-columns"}, metaVar="<file>", usage="File specifying how to group columns to combine.\nAny modules file can be used.\n(default: all columns combined)")
        public String columnsFile;
        @Option(name="-r", aliases={"-rows"}, usage="Apply to rows, by default it is applied to columns.")
        public boolean applyToRows = false;
        @Option(name="-sn", aliases={"-size-name"}, metaVar="<name>", usage="Attribute name for size.\n(default: if not specified a constant value of 1 will be used)")
        public String sizeName;
        @Option(name="-pn", aliases={"-pvalue-name"}, metaVar="<name>", usage="Attribute name having the pvalue.\n(default: use the first one)")
        public String pvalueName;
    }
}

