/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.cli;

import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import edu.upf.bg.tools.impl.AbstractTool;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gitools.cli.AnalysisArguments;
import org.gitools.model.Analysis;
import org.gitools.model.Attribute;
import org.gitools.model.KeyValue;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceManager;

public class AnalysisTool
extends AbstractTool {
    protected static final String LIST_S_FMT = "\t* %-16s%s";
    protected static final String LIST_L_FMT = "\t* %-48s%s";
    protected List<Attribute> analysisAttributes = new ArrayList<Attribute>(0);

    @Override
    public void validate(Object argsObject) throws ToolException {
        super.validate(argsObject);
        AnalysisArguments args = (AnalysisArguments)argsObject;
        if (args.analysisTitle == null) {
            args.analysisTitle = args.analysisName;
        }
        for (String attr : args.analysisAttributes) {
            String[] a = attr.split("=", 2);
            if (a.length != 2) {
                throw new ToolValidationException("Malformed analysis attribute: " + attr);
            }
            this.analysisAttributes.add(new Attribute(a[0], a[1]));
        }
    }

    protected String mimeFromFormat(String format, String fileName, String defaultMime) {
        String mime = null;
        if (fileName == null) {
            return null;
        }
        if (format != null) {
            mime = PersistenceManager.getDefault().getMimeFromFile("fake." + format);
            if (mime == null) {
                mime = format;
            }
        } else {
            mime = PersistenceManager.getDefault().getMimeFromFile(fileName);
        }
        return mime != null ? mime : defaultMime;
    }

    protected List<KeyValue> parseConfiguration(List<String> config) throws ToolValidationException {
        ArrayList<KeyValue> kv = new ArrayList<KeyValue>(config.size());
        for (String conf : config) {
            String[] c = conf.split("=", 2);
            if (c.length != 2) {
                throw new ToolValidationException("Malformed configuration parameter: " + conf);
            }
            kv.add(new KeyValue(c[0], c[1]));
        }
        return kv;
    }

    protected Properties parseProperties(List<String> config) throws ToolValidationException {
        Properties properties = new Properties();
        for (String conf : config) {
            String[] c = conf.split("=", 2);
            if (c.length != 2) {
                throw new ToolValidationException("Malformed configuration parameter: " + conf);
            }
            properties.setProperty(c[0], c[1]);
        }
        return properties;
    }

    protected void prepareGeneralAnalysisAttributes(Analysis analysis, AnalysisArguments args) {
        analysis.setTitle(args.analysisTitle);
        analysis.setDescription(args.analysisNotes);
        analysis.setAttributes(this.analysisAttributes);
    }

    protected void printDataFormats(PrintStream out) {
        FileFormat[] formats;
        out.println("Supported data formats:");
        for (FileFormat f : formats = new FileFormat[]{FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.MODULES_2C_MAP}) {
            out.println(String.format(LIST_L_FMT, f.getExtension() + " (" + f.getMime() + ")", f.getTitle()));
        }
    }

    protected void printModulesFormats(PrintStream out) {
        FileFormat[] formats;
        out.println("Supported modules formats:");
        for (FileFormat f : formats = new FileFormat[]{FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.MODULES_2C_MAP, FileFormats.DOUBLE_BINARY_MATRIX}) {
            out.println(String.format(LIST_L_FMT, f.getExtension() + " (" + f.getMime() + ")", f.getTitle()));
        }
    }
}

