/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsc.numerical.Function;
import jsc.numerical.Spline;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.BeadSlider;
import jsc.swt.plot.PlotFunction;
import jsc.swt.plot2d.FunctionPlot2D;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.VDimension;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VRectangle;

public class SplinePlot2D
extends FunctionPlot2D
implements Function {
    int m;
    int beadSize;
    double a;
    double b;
    private Spline spline;
    boolean cutOff = false;
    double minorTickGap;
    double majorTickGap;
    private double[] x;
    private double[] y;
    SplineFunc splineFunc;
    boolean changed = false;
    int n;
    Color curveColour;
    Stroke stroke;
    Paint paint;
    boolean filled;
    PlotObject po;

    public SplinePlot2D(String string, AxisModel axisModel, AxisModel axisModel2, double d, double d2, int n, double[] dArray, int n2, Color color, int n3, Color color2, Stroke stroke, Paint paint, boolean bl) {
        super(axisModel, axisModel2, string);
        this.m = n;
        this.beadSize = n2;
        if (d2 <= d) {
            throw new IllegalArgumentException("Invalid spline interval.");
        }
        this.a = d;
        this.b = d2;
        double d3 = (this.b - this.a) / ((double)n - 1.0);
        double d4 = axisModel2.getMin();
        double d5 = axisModel2.getMax();
        double d6 = axisModel2.getLength();
        this.minorTickGap = d6 / 100.0;
        this.majorTickGap = d6 / 10.0;
        this.x = new double[n];
        this.y = new double[n];
        SliderListener sliderListener = new SliderListener();
        VDimension vDimension = new VDimension(d3, d6);
        int n4 = 0;
        while (n4 < n) {
            this.x[n4] = this.a + (double)n4 * d3;
            this.y[n4] = dArray[n4];
            BeadSlider beadSlider = new BeadSlider(n4, d4, d5, dArray[n4], this.minorTickGap, this.majorTickGap, color);
            beadSlider.addChangeListener(sliderListener);
            this.addComponent(beadSlider, new VPoint(this.x[n4] - 0.5 * d3, d4), vDimension);
            ++n4;
        }
        this.spline = new Spline(n, this.x, dArray);
        this.splineFunc = new SplineFunc();
        this.n = n3;
        this.curveColour = color2;
        this.stroke = stroke;
        this.paint = paint;
        this.filled = bl;
        this.po = this.addFunction(this.splineFunc, this.a, this.b, n3, color2, stroke, paint, bl);
    }

    public SplinePlot2D(String string, AxisModel axisModel, AxisModel axisModel2, double d, double d2, int n, double[] dArray, int n2, Color color, int n3, Color color2, Stroke stroke) {
        this(string, axisModel, axisModel2, d, d2, n, dArray, n2, color, n3, color2, stroke, PlotShape.defaultPaint, false);
    }

    public SplinePlot2D(String string, AxisModel axisModel, AxisModel axisModel2, double d, double d2, int n, double[] dArray, int n2, Color color, int n3, Color color2) {
        this(string, axisModel, axisModel2, d, d2, n, dArray, n2, color, n3, color2, PlotShape.defaultStroke, PlotShape.defaultPaint, false);
    }

    public void addChangeListener(ChangeListener changeListener) {
        int n = 0;
        while (n < this.m) {
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            beadSlider.addChangeListener(changeListener);
            ++n;
        }
    }

    public double function(double d) {
        this.updateSpline();
        return this.spline.splint(d);
    }

    public BeadSlider getSlider(int n) {
        return (BeadSlider)this.getComponent(n);
    }

    public Spline getSpline() {
        this.updateSpline();
        return this.spline;
    }

    public double getX(int n) {
        return this.spline.getX(n);
    }

    public double getY(int n) {
        return this.spline.getY(n);
    }

    public double getY(double d) {
        return this.spline.splint(d);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        VDimension vDimension = this.pixelToVirtual(new Dimension(this.beadSize, this.beadSize));
        double d = vDimension.width;
        double d2 = 0.5 * d;
        int n = 0;
        while (n < this.m) {
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            this.setComponentBounds(n, new VRectangle(this.x[n] - d2, beadSlider.getMinimumValue(), d, beadSlider.getMaximumValue() - beadSlider.getMinimumValue()));
            ++n;
        }
    }

    public void setBeads(AxisModel axisModel, double d, double d2, double[] dArray) {
        if (dArray.length != this.m) {
            throw new IllegalArgumentException("Array has incorrect length.");
        }
        if (d2 <= d) {
            throw new IllegalArgumentException("Invalid spline interval.");
        }
        this.a = d;
        this.b = d2;
        double d3 = (this.b - this.a) / ((double)this.m - 1.0);
        int n = 0;
        while (n < this.m) {
            this.x[n] = this.a + (double)n * d3;
            this.y[n] = dArray[n];
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            beadSlider.setRealValue(dArray[n]);
            ++n;
        }
        this.rescaleHorizontal(axisModel);
        this.spline = new Spline(this.m, this.x, dArray);
        this.removeObject(this.po);
        this.po = this.addFunction(this.splineFunc, this.a, this.b, this.n, this.curveColour, this.stroke, this.paint, this.filled);
        this.changed = true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setCutOff(boolean bl) {
        this.cutOff = bl;
    }

    public void setFocusColour(Color color) {
        int n = 0;
        while (n < this.m) {
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            beadSlider.setFocusColour(color);
            ++n;
        }
    }

    public void setSliderY(double d, double d2, double[] dArray) {
        double[] dArray2 = new double[this.m];
        double[] dArray3 = new double[this.m];
        int n = 0;
        while (n < this.m) {
            dArray2[n] = d;
            dArray3[n] = d2;
            ++n;
        }
        this.setSliderY(dArray2, dArray3, dArray);
    }

    public void setSliderY(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != this.m || dArray2.length != this.m || dArray3.length != this.m) {
            throw new IllegalArgumentException("Array has incorrect length.");
        }
        int n = 0;
        while (n < this.m) {
            this.y[n] = dArray3[n];
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            if (dArray[n] >= dArray2[n]) {
                throw new IllegalArgumentException("Invalid slider ordinates.");
            }
            beadSlider.rescale(dArray[n], dArray2[n], dArray3[n], this.minorTickGap, this.majorTickGap);
            ++n;
        }
        this.spline = new Spline(this.m, this.x, dArray3);
        this.removeObject(this.po);
        this.po = this.addFunction(this.splineFunc, this.a, this.b, this.n, this.curveColour, this.stroke, this.paint, this.filled);
        this.changed = true;
    }

    private void updateSpline() {
        int n = 0;
        while (n < this.m) {
            BeadSlider beadSlider = (BeadSlider)this.getComponent(n);
            this.y[n] = beadSlider.getRealValue();
            ++n;
        }
        this.spline = new Spline(this.m, this.x, this.y);
    }

    class SplineFunc
    implements PlotFunction {
        SplineFunc() {
        }

        public double getOrdinate(double d) {
            if (SplinePlot2D.this.cutOff) {
                return Math.max(SplinePlot2D.this.verticalAxis.getMin(), SplinePlot2D.this.spline.splint(d));
            }
            return SplinePlot2D.this.spline.splint(d);
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SplinePlot2D.this.updateSpline();
            SplinePlot2D.this.removeObject(SplinePlot2D.this.po);
            SplinePlot2D.this.po = SplinePlot2D.this.addFunction(SplinePlot2D.this.splineFunc, SplinePlot2D.this.a, SplinePlot2D.this.b, SplinePlot2D.this.n, SplinePlot2D.this.curveColour, SplinePlot2D.this.stroke, SplinePlot2D.this.paint, SplinePlot2D.this.filled);
            SplinePlot2D.this.changed = true;
        }
    }
}

