/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class PrintMenu
extends JMenu {
    public JMenuItem pageSetup;
    public JMenuItem print;
    public PageSetupAction pageSetupAction;
    public PrintAction printAction;
    Component parentComponent;
    PageFormat pageFormat;
    Printable printer;

    public PrintMenu(Component component, PageFormat pageFormat, Printable printable) {
        super("Print");
        this.parentComponent = component;
        this.pageFormat = pageFormat;
        this.printer = printable;
        this.setMnemonic('P');
        this.pageSetupAction = new PageSetupAction("Page Setup...");
        this.pageSetup = this.add(this.pageSetupAction);
        this.pageSetup.setMnemonic('U');
        ImageIcon imageIcon = null;
        URL uRL = this.getClass().getResource("images/print24.gif");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        this.printAction = new PrintAction("Print...", imageIcon);
        this.print = this.add(this.printAction);
        this.print.setMnemonic('P');
        this.print.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.pageSetupAction.setEnabled(bl);
        this.printAction.setEnabled(bl);
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(PrintMenu.this.printer, PrintMenu.this.pageFormat);
                printerJob.setPageable(new Pager(1));
                if (!printerJob.printDialog()) break block2;
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(PrintMenu.this.parentComponent, "Cannot print: " + printerException.getMessage(), "System error", 0);
                }
            }
        }
    }

    class PageSetupAction
    extends AbstractAction {
        public PageSetupAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PrintMenu.this.pageFormat = printerJob.pageDialog(PrintMenu.this.pageFormat);
        }
    }

    class Pager
    implements Pageable {
        int pageCount;

        public Pager(int n) {
            this.pageCount = n;
        }

        public int getNumberOfPages() {
            return this.pageCount;
        }

        public PageFormat getPageFormat(int n) {
            return PrintMenu.this.pageFormat;
        }

        public Printable getPrintable(int n) {
            return PrintMenu.this.printer;
        }
    }
}

