/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.StatisticalMathFunction;
import jsc.swt.control.LegalCharactersField;
import jsc.swt.datatable.CalculatorVariables;
import jsc.swt.datatable.DataCalculator;
import jsc.swt.datatable.DataTable;

public class StatisticalCalculator
extends DataCalculator {
    StatisticalMathFunction smf;
    CalculatorVariables cv;
    JOptionPane pane;
    JDialog dialog;
    Vector names;
    JList nameList = new JList();
    LegalCharactersField expression = new LegalCharactersField(0, "");
    JComboBox expressionCombo;
    JTextField errorMessage;

    public StatisticalCalculator(Component component, DataTable dataTable) {
        super(component, dataTable);
        JComponent jComponent;
        Serializable serializable;
        this.updateNames();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        this.expression.addActionListener(new CalcButtonListener());
        this.expressionCombo = new JComboBox();
        this.expressionCombo.setEditable(true);
        this.expressionCombo.setEditor(new ExpressionEditor());
        this.expressionCombo.setMaximumRowCount(10);
        this.errorMessage = new JTextField();
        this.errorMessage.setEditable(false);
        this.errorMessage.setFocusable(false);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 2, 2));
        jPanel2.add(this.expressionCombo);
        jPanel2.add(this.errorMessage);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nameList.setSelectionMode(0);
        this.nameList.addMouseListener(new NameListMouseListener());
        this.nameList.addKeyListener(new NameListKeyListener());
        this.nameList.addFocusListener(new NameListFocusListener());
        JScrollPane jScrollPane = new JScrollPane(this.nameList);
        jScrollPane.setPreferredSize(new Dimension(150, 200));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        ButtonListener buttonListener = new ButtonListener();
        Font font = new Font("Monospaced", 0, 14);
        JPanel jPanel4 = new JPanel(new GridLayout(7, 3, 2, 2));
        String[] stringArray = new String[]{"+", "-", "*", "/", "^", "%", "<", "<=", "=", ">", ">=", "~=", "|", "&", "~", "(", ")", " ", "pi", "e"};
        int n = 0;
        while (n < stringArray.length) {
            serializable = new JButton(stringArray[n]);
            serializable.setFont(font);
            serializable.addActionListener(buttonListener);
            if (n == 17) {
                serializable.setVisible(false);
            }
            jPanel4.add((Component)serializable);
            ++n;
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        serializable = new Font("SanSerif", 0, 12);
        JPanel jPanel5 = new JPanel(new GridLayout(10, 2, 2, 2));
        String[] stringArray2 = new String[]{"log", "exp", "sqrt", "abs", "int", "nint", "sin", "asin", "cos", "acos", "tan", "atan", "deg", "rad", "sinh", "cosh", "tanh", "sign", "gam", "lgam"};
        n = 0;
        while (n < stringArray2.length) {
            jComponent = new JButton(stringArray2[n].toUpperCase());
            jComponent.setFont((Font)serializable);
            ((AbstractButton)jComponent).addActionListener(buttonListener);
            jPanel5.add(jComponent);
            ++n;
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        jComponent = new JPanel(new GridLayout(4, 3, 2, 2));
        JButton[] jButtonArray = new JButton[10];
        n = 0;
        while (n <= 9) {
            jButtonArray[n] = new JButton(new Integer(n).toString());
            jButtonArray[n].addActionListener(buttonListener);
            jButtonArray[n].setFont((Font)serializable);
            ++n;
        }
        jComponent.add(jButtonArray[7]);
        jComponent.add(jButtonArray[8]);
        jComponent.add(jButtonArray[9]);
        jComponent.add(jButtonArray[4]);
        jComponent.add(jButtonArray[5]);
        jComponent.add(jButtonArray[6]);
        jComponent.add(jButtonArray[1]);
        jComponent.add(jButtonArray[2]);
        jComponent.add(jButtonArray[3]);
        jComponent.add(jButtonArray[0]);
        JButton jButton = new JButton(".");
        jButton.addActionListener(buttonListener);
        jComponent.add(jButton);
        JButton jButton2 = new JButton("E");
        jButton2.addActionListener(buttonListener);
        jComponent.add(jButton2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel3.add((Component)jComponent, gridBagConstraints);
        jPanel.add((Component)jPanel3, "Center");
        JButton jButton3 = new JButton("Calculate");
        jButton3.addActionListener(new CalcButtonListener());
        JButton jButton4 = new JButton("Clear");
        jButton4.addActionListener(new ClearButtonListener());
        JButton jButton5 = new JButton("Close");
        jButton5.addActionListener(new CloseButtonListener());
        jButton5.setDefaultCapable(false);
        this.pane = new JOptionPane(jPanel, -1, -1, null, new Object[]{jButton4, jButton3, jButton5});
        this.dialog = this.pane.createDialog(component, "Calculations on variables dialogue");
        this.dialog.setModal(false);
        this.dialog.setResizable(false);
    }

    void insertToken(String string) {
        int n = this.expression.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer(this.expression.getText());
        stringBuffer.insert(n, string);
        this.expression.setText(stringBuffer.toString());
    }

    public void setSize(int n, int n2) {
        this.dialog.setSize(n, n2);
        this.dialog.setLocationRelativeTo(this.parentComponent);
    }

    public void show() {
        if (this.expressionCombo.getItemCount() > 1) {
            this.expression.setText("");
        }
        this.errorMessage.setText("");
        this.dialog.show();
    }

    public void updateNames() {
        this.cv = new CalculatorVariables(this.dataTable);
        this.smf = new StatisticalMathFunction(this.cv);
        this.expression.setLegalCharacters(this.smf.getLegalCharacters());
        this.names = this.cv.getNames();
        this.nameList.setListData(this.names);
    }

    class NameListMouseListener
    extends MouseAdapter {
        NameListMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = StatisticalCalculator.this.nameList.locationToIndex(mouseEvent.getPoint());
                if (n < 0 || n >= StatisticalCalculator.this.names.size()) {
                    return;
                }
                Object e = StatisticalCalculator.this.names.elementAt(n);
                String string = "\"" + e.toString() + "\"";
                StatisticalCalculator.this.insertToken(string);
            }
        }
    }

    class NameListKeyListener
    extends KeyAdapter {
        NameListKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n = StatisticalCalculator.this.nameList.getSelectedIndex();
            if (n < 0 || n >= StatisticalCalculator.this.names.size()) {
                return;
            }
            Object e = StatisticalCalculator.this.names.elementAt(n);
            String string = "\"" + e.toString() + "\"";
            StatisticalCalculator.this.insertToken(string);
        }
    }

    class NameListFocusListener
    extends FocusAdapter {
        NameListFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            StatisticalCalculator.this.nameList.setSelectedIndex(0);
        }
    }

    class ExpressionEditor
    implements ComboBoxEditor {
        ExpressionEditor() {
        }

        public void addActionListener(ActionListener actionListener) {
            StatisticalCalculator.this.expression.addActionListener(actionListener);
        }

        public Component getEditorComponent() {
            return StatisticalCalculator.this.expression;
        }

        public Object getItem() {
            return StatisticalCalculator.this.expression.getText();
        }

        public void removeActionListener(ActionListener actionListener) {
            StatisticalCalculator.this.expression.removeActionListener(actionListener);
        }

        public void selectAll() {
            StatisticalCalculator.this.expression.selectAll();
        }

        public void setItem(Object object) {
            if (object != null) {
                StatisticalCalculator.this.expression.setText(object.toString());
                StatisticalCalculator.this.errorMessage.setText("");
            }
        }
    }

    class CloseButtonListener
    implements ActionListener {
        CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatisticalCalculator.this.dialog.dispose();
        }
    }

    class ClearButtonListener
    implements ActionListener {
        ClearButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatisticalCalculator.this.expression.setText("");
            StatisticalCalculator.this.errorMessage.setText("");
        }
    }

    class CalcButtonListener
    implements ActionListener {
        CalcButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                StatisticalCalculator.this.errorMessage.setText("");
                try {
                    String string = StatisticalCalculator.this.expression.getText();
                    double d = StatisticalCalculator.this.smf.parse(string);
                    StatisticalCalculator.this.expressionCombo.addItem(string);
                    StatisticalCalculator.this.expressionCombo.setSelectedIndex(StatisticalCalculator.this.expressionCombo.getItemCount() - 1);
                    if (!Double.isNaN(d)) {
                        StatisticalCalculator.this.errorMessage.setText("Value of expression = " + d);
                        break block3;
                    }
                    int n = StatisticalCalculator.this.dataTable.calculate(StatisticalCalculator.this.smf, StatisticalCalculator.this.cv);
                    String string2 = StatisticalCalculator.this.smf.getParsedExpression();
                    StatisticalCalculator.this.dataTable.setColumnName(n, string2.replace('\"', ' '));
                    StatisticalCalculator.this.errorMessage.setText(StatisticalCalculator.this.smf.getEvalCount() + " row calculations stored in new column " + (n + 1));
                    StatisticalCalculator.this.updateNames();
                }
                catch (MathFunctionException mathFunctionException) {
                    StatisticalCalculator.this.errorMessage.setText(mathFunctionException.getMessage());
                }
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            StatisticalCalculator.this.insertToken(string);
        }
    }
}

