/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;

public class ToolBar
extends JToolBar {
    private Color focusColour = Color.red;
    private Dimension buttonSize;

    public ToolBar(String string, Dimension dimension) {
        super(string);
        this.buttonSize = dimension;
        this.setBorder(new EtchedBorder());
        this.setFloatable(false);
    }

    public JButton add(Action action, String string) {
        return this.add(action, string, false);
    }

    public JButton add(Action action, String string, boolean bl) {
        JButton jButton = super.add(action);
        jButton.setPreferredSize(this.buttonSize);
        jButton.setText("");
        jButton.setToolTipText(string);
        jButton.setFocusable(bl);
        if (bl) {
            jButton.addFocusListener(new KeyboardFocusListener(jButton));
        }
        return jButton;
    }

    public void addToDesktop(JDesktopPane jDesktopPane) {
        Dimension dimension = this.getPreferredSize();
        this.setBounds(0, 0, dimension.width, dimension.height);
        jDesktopPane.add((Component)this, JLayeredPane.PALETTE_LAYER);
    }

    public void setFocusColour(Color color) {
        this.focusColour = color;
    }

    public int getVisibleHeight() {
        return this.isVisible() ? this.getPreferredSize().height : 0;
    }

    class KeyboardFocusListener
    extends FocusAdapter {
        JButton button;
        Color colour;

        public KeyboardFocusListener(JButton jButton) {
            this.button = jButton;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.colour = this.button.getBackground();
            this.button.setBackground(ToolBar.this.focusColour);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.button.setBackground(this.colour);
        }
    }
}

