/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.combinatorics.Permutation;
import jsc.combinatorics.Permutations;
import jsc.descriptive.DoubleTally;
import jsc.distributions.Discrete;

public class RankSumOfSquares
extends Discrete {
    protected int n;
    protected int k;
    private double tolerance = 1.0E-14;
    private double Rbar;
    private int[] perm;
    private int[][] R;
    private DoubleTally S;
    private Permutations[] perms;

    public RankSumOfSquares(int n, int n2) {
        this.n = n;
        this.k = n2;
        if (n < 2) {
            throw new IllegalArgumentException("Less than two rankings.");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than two objects.");
        }
        this.S = new DoubleTally(166, 10, this.tolerance);
        this.R = new int[n][n2];
        this.perm = new int[n2];
        this.Rbar = 0.5 * (double)n * ((double)n2 + 1.0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            this.R[0][n4] = n4 + 1;
            ++n4;
        }
        this.perms = new Permutations[n];
        n3 = 0;
        while (n3 < n) {
            this.perms[n3] = new Permutations(n2);
            ++n3;
        }
        this.recurse(1);
        this.setDistribution(this.S);
        this.S = null;
        this.R = null;
        this.perm = null;
        this.perms = null;
    }

    private void recurse(int n) {
        while (this.perms[n].hasNext()) {
            Permutation permutation = this.perms[n].nextPermutation();
            this.perm = permutation.toIntArray();
            int n2 = 0;
            while (n2 < this.k) {
                this.R[n][n2] = this.perm[n2];
                ++n2;
            }
            if (n == this.n - 1) {
                this.S.addValue(this.getS());
                continue;
            }
            this.recurse(n + 1);
            this.perms[n + 1].reset();
        }
    }

    public double criticalValue(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        int n = this.valueCount - 1;
        while (n >= 0) {
            if ((d2 += this.probs[n]) == d) {
                return this.values[n];
            }
            if (d2 > d) {
                return n < this.valueCount - 1 ? this.values[n + 1] : -1.0;
            }
            --n;
        }
        return this.minValue;
    }

    private double getS() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.k) {
            d = 0.0;
            int n2 = 0;
            while (n2 < this.n) {
                d += (double)this.R[n2][n];
                ++n2;
            }
            double d3 = d - this.Rbar;
            d2 += d3 * d3;
            ++n;
        }
        return d2;
    }

    public String toString() {
        return new String("Rank sum of squares distribution: " + this.n + " blocks, " + this.k + " treatments.");
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = -2;
            int n2 = 2;
            System.out.println("n = " + n + " m = " + n2);
            long l = System.currentTimeMillis();
            RankSumOfSquares rankSumOfSquares = new RankSumOfSquares(n2, n);
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            int n3 = 0;
            while (n3 < rankSumOfSquares.getValueCount()) {
                int n4 = (int)rankSumOfSquares.getValue(n3);
                System.out.println("S = " + n4 + " P = " + rankSumOfSquares.upperTailProb(n4));
                ++n3;
            }
        }
    }
}

