/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import java.util.Arrays;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Gamma;
import jsc.util.Maths;

public class Beta
extends AbstractDistribution {
    private static final double ACU63 = 5.0E-17;
    private static final double ACU109 = 1.0E-28;
    private static final double LOWER = 1.0E-4;
    private static final double UPPER = 0.9999;
    private static final double CONST1 = 2.30753;
    private static final double CONST2 = 0.27061;
    private static final double CONST3 = 0.99229;
    private static final double CONST4 = 0.04481;
    private double p;
    private double q;
    private double logB;
    private static final int GR = 0;
    private static final int OS = 1;
    private static final int AS134 = 2;
    private static final int ATKINSON79_5_2 = 52;
    private static final double TOL = 1.0E-14;
    private int randomMethod;
    private boolean reverseOrder = false;
    private int n;
    private double am1;
    private double bm1;
    private double arecip;
    private double brecip;
    private double t;
    private double r;
    private Gamma Gp;
    private Gamma Gq;
    private double pStar;
    private double qStar;
    private double s1;
    private double s2;

    public Beta(double d, double d2) {
        this.setShape(d, d2);
    }

    public double cdf(double d) {
        return Beta.incompleteBeta(d, this.p, this.q, this.logB);
    }

    public double getP() {
        return this.p;
    }

    public double getQ() {
        return this.q;
    }

    public static double incompleteBeta(double d, double d2, double d3, double d4) {
        boolean bl;
        double d5;
        double d6;
        double d7;
        double d8 = d;
        if (d2 <= 0.0 || d3 <= 0.0 || d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid argument of incomplete beta function ratio.");
        }
        if (d == 0.0 || d == 1.0) {
            return d8;
        }
        double d9 = d2 + d3;
        double d10 = 1.0 - d;
        if (d2 >= d9 * d) {
            d7 = d;
            d6 = d2;
            d5 = d3;
            bl = false;
        } else {
            d7 = d10;
            d10 = d;
            d6 = d3;
            d5 = d2;
            bl = true;
        }
        double d11 = 1.0;
        double d12 = 1.0;
        d8 = 1.0;
        int n = (int)(d5 + d10 * d9);
        double d13 = d7 / d10;
        double d14 = d5 - d12;
        if (n == 0) {
            d13 = d7;
        }
        while (true) {
            d11 = d11 * d14 * d13 / (d6 + d12);
            d14 = Math.abs(d11);
            if (d14 <= 5.0E-17 && d14 <= 5.0E-17 * (d8 += d11)) break;
            d12 += 1.0;
            if (--n >= 0) {
                d14 = d5 - d12;
                if (n != 0) continue;
                d13 = d7;
                continue;
            }
            d14 = d9;
            d9 += 1.0;
        }
        d8 = d8 * Math.exp(d6 * Math.log(d7) + (d5 - 1.0) * Math.log(d10) - d4) / d6;
        if (bl) {
            d8 = 1.0 - d8;
        }
        return d8;
    }

    public double inverseCdf(double d) {
        return Beta.inverseIncompleteBeta(this.p, this.q, this.logB, d);
    }

    public static double inverseIncompleteBeta(double d, double d2, double d3, double d4) {
        double d5;
        boolean bl;
        double d6;
        double d7;
        double d8;
        double d9 = d4;
        if (d <= 0.0 || d2 <= 0.0 || d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("Invalid argument of inverse of incomplete beta function ratio.");
        }
        if (d4 == 0.0 || d4 == 1.0) {
            return d4;
        }
        if (d4 <= 0.5) {
            d8 = d4;
            d7 = d;
            d6 = d2;
            bl = false;
        } else {
            d8 = 1.0 - d4;
            d7 = d2;
            d6 = d;
            bl = true;
        }
        double d10 = Math.sqrt(-Math.log(d8 * d8));
        double d11 = d10 - (2.30753 + 0.27061 * d10) / (1.0 + (0.99229 + 0.04481 * d10) * d10);
        if (d7 > 1.0 && d6 > 1.0) {
            d10 = (d11 * d11 - 3.0) / 6.0;
            double d12 = 1.0 / (d7 + d7 - 1.0);
            d5 = 1.0 / (d6 + d6 - 1.0);
            double d13 = 2.0 / (d12 + d5);
            double d14 = d11 * Math.sqrt(d13 + d10) / d13 - (d5 - d12) * (d10 + 0.8333333333333334 - 2.0 / (3.0 * d13));
            d9 = d7 / (d7 + d6 * Math.exp(d14 + d14));
        } else {
            d10 = d6 + d6;
            d5 = 1.0 / (9.0 * d6);
            d9 = (d5 = d10 * Math.pow(1.0 - d5 + d11 * Math.sqrt(d5), 3.0)) <= 0.0 ? 1.0 - Math.exp((Math.log((1.0 - d8) * d6) + d3) / d6) : ((d5 = (4.0 * d7 + d10 - 2.0) / d5) <= 1.0 ? Math.exp((Math.log(d8 * d7) + d3) / d7) : 1.0 - 2.0 / (d5 + 1.0));
        }
        d10 = 1.0 - d7;
        d5 = 1.0 - d6;
        double d15 = 0.0;
        double d16 = 1.0;
        double d17 = 1.0;
        if (d9 < 1.0E-4) {
            d9 = 1.0E-4;
        }
        if (d9 > 0.9999) {
            d9 = 0.9999;
        }
        block0: while (true) {
            d11 = Beta.incompleteBeta(d9, d7, d6, d3);
            if ((d11 = (d11 - d8) * Math.exp(d3 + d10 * Math.log(d9) + d5 * Math.log(1.0 - d9))) * d15 <= 0.0) {
                d17 = d16;
            }
            double d18 = 1.0;
            while (true) {
                double d19;
                if ((d16 = (d19 = d18 * d11) * d19) >= d17) {
                    d18 /= 3.0;
                    continue;
                }
                double d20 = d9 - d19;
                if (d20 >= 0.0 && d20 <= 1.0) {
                    if (d17 <= 1.0E-28 || d11 * d11 <= 1.0E-28) {
                        return bl ? 1.0 - d9 : d9;
                    }
                    if (d20 == 0.0 || d20 == 1.0) {
                        d18 /= 3.0;
                        continue;
                    }
                    if (d20 == d9) {
                        return bl ? 1.0 - d9 : d9;
                    }
                    d9 = d20;
                    d15 = d11;
                    continue block0;
                }
                d18 /= 3.0;
            }
            break;
        }
    }

    public double mean() {
        return this.p / (this.p + this.q);
    }

    public double pdf(double d) {
        if (d > 0.0 && d < 1.0 || d == 0.0 && this.p >= 1.0 || d == 1.0 && this.q >= 1.0) {
            if (d == 0.0) {
                return this.p == 1.0 ? this.q : 0.0;
            }
            if (d == 1.0) {
                return this.q == 1.0 ? this.p : 0.0;
            }
            return Math.exp((this.p - 1.0) * Math.log(d) + (this.q - 1.0) * Math.log(1.0 - d) - this.logB);
        }
        throw new IllegalArgumentException("Invalid variate-value.");
    }

    private double random52() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        do {
            d5 = this.rand.nextDouble();
            d4 = this.rand.nextDouble();
        } while (!(d5 > this.r ? this.s2 * d4 <= (d3 = Math.pow(d2 = 1.0 - (1.0 - this.t) * Math.pow((1.0 - d5) / (1.0 - this.r), 1.0 / this.qStar), this.p - 1.0)) : this.s1 * d4 <= (d = Math.pow(1.0 - (d2 = this.t * Math.pow(d5 / this.r, 1.0 / this.pStar)), this.q - 1.0))));
        return d2;
    }

    public double random() {
        if (this.randomMethod == 0) {
            double d = this.Gp.random();
            double d2 = d + this.Gq.random();
            if (d2 == 0.0) {
                return 1.0;
            }
            return d / d2;
        }
        if (this.randomMethod == 2) {
            double d;
            double d3;
            double d4;
            do {
                d4 = this.rand.nextDouble();
                d = -Math.log(1.0 - this.rand.nextDouble());
            } while (!(d4 > this.r ? -this.am1 * Math.log((d3 = 1.0 - (1.0 - this.t) * Math.pow((1.0 - d4) / (1.0 - this.r), this.brecip)) / this.t) <= d : -this.bm1 * Math.log(1.0 - (d3 = this.t * Math.pow(d4 / this.r, this.arecip))) <= d));
            return this.reverseOrder ? 1.0 - d3 : d3;
        }
        if (this.randomMethod == 52) {
            return this.random52();
        }
        double[] dArray = new double[this.n];
        int n = 0;
        while (n < this.n) {
            dArray[n] = this.rand.nextDouble();
            ++n;
        }
        Arrays.sort(dArray);
        return dArray[(int)this.p - 1];
    }

    private void tOpt(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Alpha out of range.");
        }
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("Beta out of range.");
        }
        this.am1 = d - 1.0;
        double d7 = this.am1 / (this.am1 - d2);
        if (1.0 - d7 * d7 >= 1.0) {
            throw new IllegalArgumentException("Alpha too near 1 or beta too large.");
        }
        this.bm1 = d2 - 1.0;
        this.arecip = 1.0 / d;
        this.brecip = 1.0 / d2;
        double d8 = 0.0;
        double d9 = this.am1;
        double d10 = 1.0;
        double d11 = d2;
        while (!(Math.abs(d6 = (d5 = d2 * (d4 = (d8 * d11 - d10 * d9) / (d11 - d9))) + Math.pow(d3 = 1.0 - d4, this.bm1) * (this.am1 * d3 - d5)) < 1.0E-14)) {
            if (d6 * d9 < 0.0) {
                d10 = d8;
                d11 = d9;
                d8 = d4;
                d9 = d6;
                continue;
            }
            d8 = d4;
            d9 = d6;
            d11 /= 1.0;
        }
        this.t = d4;
        this.r = d5 / (d5 + d * Math.pow(d3, d2));
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        if (this.randomMethod == 0) {
            this.Gp.setSeed(this.rand.nextLong());
            this.Gq.setSeed(this.rand.nextLong() + 1L);
        }
    }

    private double S(double d, double d2) {
        double d3 = d - 1.0;
        double d4 = d2 - 1.0;
        double d5 = d + d2 - 2.0;
        return Math.pow(d3, d3) * Math.pow(d4, d4) / Math.pow(d5, d5);
    }

    public void setShape(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid shape parameter.");
        }
        this.p = d;
        this.q = d2;
        this.logB = Maths.lnB(d, d2);
        if (d == Math.floor(d) && d2 == Math.floor(d2) && d + d2 < 10.0) {
            this.randomMethod = 1;
            this.n = (int)(d + d2 - 1.0);
        } else if (d < 1.0 && d2 > 1.0) {
            this.randomMethod = 2;
            this.reverseOrder = false;
            this.tOpt(d, d2);
        } else if (d > 1.0 && d2 < 1.0) {
            this.randomMethod = 2;
            this.reverseOrder = true;
            this.tOpt(d2, d);
        } else if (d < 1.0 && d2 < 1.0) {
            this.randomMethod = 52;
            this.pStar = d;
            this.qStar = d2;
            this.t = Math.sqrt(d * (1.0 - d)) / (Math.sqrt(d * (1.0 - d)) + Math.sqrt(d2 * (1.0 - d2)));
            this.s1 = Math.pow(1.0 - this.t, d2 - 1.0);
            this.s2 = Math.pow(this.t, d - 1.0);
            this.r = d2 * this.t / (d2 * this.t + d * (1.0 - this.t));
        } else {
            this.randomMethod = 0;
            this.Gp = new Gamma(d, 1.0);
            this.Gq = new Gamma(d2, 1.0);
            this.Gq.setSeed(this.rand.nextLong());
        }
    }

    public String toString() {
        return new String("Beta distribution: p = " + this.p + ", q = " + this.q + ".");
    }

    public double variance() {
        return this.p * this.q / ((this.p + this.q + 1.0) * (this.p + this.q) * (this.p + this.q));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000000;
            double d = 50.1;
            double d2 = 50.1;
            Beta beta = new Beta(d, d2);
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                beta.random();
                ++n2;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
        }
    }
}

