/*
 * Decompiled with CFR 0.152.
 */
package jsc.contingencytables;

import java.util.Vector;
import jsc.descriptive.CategoricalTally;
import jsc.util.Arrays;

public class ContingencyTable {
    private int N;
    private int rowCount;
    private int colCount;
    private Vector rowLabels;
    private Vector colLabels;
    private int[][] O;

    public ContingencyTable(String[] stringArray, String[] stringArray2) {
        this.N = stringArray.length;
        if (this.N != stringArray2.length) {
            throw new IllegalArgumentException("Data arrays do not match.");
        }
        CategoricalTally categoricalTally = new CategoricalTally("", stringArray);
        CategoricalTally categoricalTally2 = new CategoricalTally("", stringArray2);
        this.rowCount = categoricalTally.getNumberOfBins();
        this.colCount = categoricalTally2.getNumberOfBins();
        this.rowLabels = new Vector(this.rowCount);
        this.colLabels = new Vector(this.colCount);
        int n = 0;
        while (n < this.rowCount) {
            this.rowLabels.add(categoricalTally.getLabel(n));
            ++n;
        }
        n = 0;
        while (n < this.colCount) {
            this.colLabels.add(categoricalTally2.getLabel(n));
            ++n;
        }
        this.O = new int[this.rowCount][this.colCount];
        n = 0;
        while (n < this.N) {
            int[] nArray = this.O[categoricalTally.indexOf(stringArray[n])];
            int n2 = categoricalTally2.indexOf(stringArray2[n]);
            nArray[n2] = nArray[n2] + 1;
            ++n;
        }
    }

    public ContingencyTable(int[] nArray, int[] nArray2) {
        this(Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2));
    }

    public ContingencyTable(String[] stringArray, String[] stringArray2, int[][] nArray) {
        this.rowCount = stringArray.length;
        this.colCount = stringArray2.length;
        if (this.rowCount < 1) {
            throw new IllegalArgumentException("No row labels.");
        }
        if (this.colCount < 1) {
            throw new IllegalArgumentException("No column labels.");
        }
        if (this.rowCount != nArray.length) {
            throw new IllegalArgumentException("Number of row labels do not match frequencies.");
        }
        int n = 0;
        while (n < this.rowCount) {
            if (nArray[n].length != this.colCount) {
                throw new IllegalArgumentException("Number of column labels do not match frequencies.");
            }
            ++n;
        }
        this.rowLabels = new Vector(this.rowCount);
        this.colLabels = new Vector(this.colCount);
        n = 0;
        while (n < this.rowCount) {
            this.rowLabels.add(stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < this.colCount) {
            this.colLabels.add(stringArray2[n]);
            ++n;
        }
        this.O = new int[this.rowCount][this.colCount];
        this.N = 0;
        n = 0;
        while (n < this.rowCount) {
            int n2 = 0;
            while (n2 < this.colCount) {
                if (nArray[n][n2] < 0) {
                    throw new IllegalArgumentException("Negative frequency.");
                }
                this.N += nArray[n][n2];
                this.O[n][n2] = nArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public ContingencyTable(int[] nArray, int[] nArray2, int[][] nArray3) {
        this(Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2), nArray3);
    }

    public ContingencyTable(int[][] nArray) {
        this(Arrays.sequence(0, nArray.length - 1), Arrays.sequence(0, nArray[0].length - 1), nArray);
    }

    public Object clone() {
        return this.copy();
    }

    public ContingencyTable copy() {
        String[] stringArray = new String[this.rowCount];
        String[] stringArray2 = new String[this.colCount];
        int[][] nArray = new int[this.rowCount][this.colCount];
        int n = 0;
        while (n < this.rowCount) {
            stringArray[n] = (String)this.rowLabels.get(n);
            ++n;
        }
        n = 0;
        while (n < this.colCount) {
            stringArray2[n] = (String)this.colLabels.get(n);
            ++n;
        }
        n = 0;
        while (n < this.rowCount) {
            int n2 = 0;
            while (n2 < this.colCount) {
                nArray[n][n2] = this.O[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ContingencyTable(stringArray, stringArray2, nArray);
    }

    public int[][] getFrequencies() {
        return this.O;
    }

    public int getFrequency(int n, int n2) {
        return this.O[n][n2];
    }

    public int getN() {
        return this.N;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int[] getRowData(String string) {
        int n = this.rowLabels.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.O[n];
    }

    public int[] getRowData(int n) {
        return this.O[n];
    }

    public String getRowLabel(int n) {
        return (String)this.rowLabels.get(n);
    }

    public Vector getRowLabels() {
        return this.rowLabels;
    }

    public int[] getRowTotals() {
        int[] nArray = new int[this.rowCount];
        int n = 0;
        while (n < this.rowCount) {
            nArray[n] = 0;
            int n2 = 0;
            while (n2 < this.colCount) {
                int n3 = n;
                nArray[n3] = nArray[n3] + this.O[n][n2];
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public boolean hasRowLabel(String string) {
        return this.rowLabels.contains(string);
    }

    public int indexOfRow(String string) {
        return this.rowLabels.indexOf(string);
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int[] getColumnData(String string) {
        int n = this.colLabels.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.getColumnData(n);
    }

    public int[] getColumnData(int n) {
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        while (n2 < this.rowCount) {
            nArray[n2] = this.O[n2][n];
            ++n2;
        }
        return nArray;
    }

    public String getColumnLabel(int n) {
        return (String)this.colLabels.get(n);
    }

    public Vector getColumnLabels() {
        return this.colLabels;
    }

    public int[] getColumnTotals() {
        int[] nArray = new int[this.colCount];
        int n = 0;
        while (n < this.colCount) {
            nArray[n] = 0;
            int n2 = 0;
            while (n2 < this.rowCount) {
                int n3 = n;
                nArray[n3] = nArray[n3] + this.O[n2][n];
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public boolean hasColumnLabel(String string) {
        return this.colLabels.contains(string);
    }

    public int indexOfColumn(String string) {
        return this.colLabels.indexOf(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nContingency table\n");
        int n = 0;
        while (n < this.colCount) {
            stringBuffer.append("\t" + this.getColumnLabel(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.rowCount) {
            stringBuffer.append("\n" + this.getRowLabel(n2));
            n = 0;
            while (n < this.colCount) {
                stringBuffer.append("\t" + this.O[n2][n]);
                ++n;
            }
            ++n2;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"Improved", "Same or worse"};
            String[] stringArray3 = new String[]{"Placebo", "Drug 1", "Drug 2", "Drug 3", "Drug 4", "Drug 5"};
            int[][] nArrayArray = new int[][]{{8, 12, 21, 15, 14, 19}, {22, 18, 9, 15, 16, 11}};
            ContingencyTable contingencyTable = new ContingencyTable(stringArray2, stringArray3, (int[][])nArrayArray);
            System.out.println(contingencyTable.toString());
            int[] nArray = new int[]{2, 1, 2, 2, 2, 3, 3, 2, 1, 1, 2, 3, 2, 3, 2, 3, 1, 2, 3, 2};
            int[] nArray2 = new int[]{8, 8, 9, 8, 9, 9, 9, 8, 8, 9, 8, 8, 9, 8, 8, 9, 9, 8, 8, 9};
            contingencyTable = new ContingencyTable(nArray, nArray2);
            System.out.println(contingencyTable.toString());
            ContingencyTable contingencyTable2 = contingencyTable.copy();
            System.out.println(contingencyTable2.toString());
        }
    }
}

