/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gitools.ui.platform.dialog.AbstractDialog;
import org.gitools.ui.platform.dialog.DialogButtonsPanel;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.help.Help;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.help.HelpException;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.IWizardUpdateListener;

public class WizardDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    protected Map<String, JComponent> pageControlsMap;
    protected IWizardPage currentPage;
    protected Stack<IWizardPage> pageHistory;
    protected JPanel pagePanel;
    protected JButton helpButton;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton cancelButton;
    protected boolean cancelled;

    public WizardDialog(Window owner, IWizard wizard) {
        super(owner, wizard.getTitle(), wizard.getLogo());
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLocationRelativeTo(owner);
        this.pageControlsMap = new HashMap<String, JComponent>();
        this.pageHistory = new Stack();
        wizard.addWizardUpdateListener(new IWizardUpdateListener(){

            @Override
            public void pageUpdated(IWizardPage page) {
                WizardDialog.this.updateState();
            }

            @Override
            public void wizardUpdated(IWizard wizard) {
                WizardDialog.this.updateState();
            }
        });
        wizard.addPages();
        this.setCurrentPage(wizard.getStartingPage());
        this.cancelled = true;
    }

    public IWizard getWizard() {
        return this.currentPage != null ? this.currentPage.getWizard() : null;
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected final void setCurrentPage(IWizardPage page) {
        this.setCurrentPage(page, true);
    }

    protected final void setCurrentPage(IWizardPage page, boolean updateHistory) {
        if (this.currentPage != null) {
            if (updateHistory) {
                this.pageHistory.push(this.currentPage);
            }
            this.currentPage.updateModel();
            this.getWizard().pageLeft(this.currentPage);
        }
        this.currentPage = page;
        this.getWizard().setCurrentPage(page);
        JComponent contents = this.getPageContents(page.getId());
        if (contents == null) {
            contents = new JPanel();
        }
        this.pagePanel.removeAll();
        this.pagePanel.add((Component)contents, "Center");
        contents.repaint();
        this.updateState();
        page.updateControls();
        this.getWizard().pageEntered(page);
    }

    private void updateButtons() {
        IWizardPage page = this.getCurrentPage();
        IWizard wizard = page.getWizard();
        this.backButton.setEnabled(this.pageHistory.size() > 0);
        this.nextButton.setEnabled(page.isComplete() && !wizard.isLastPage(page));
        this.finishButton.setEnabled(page.getWizard().canFinish());
        this.cancelButton.setEnabled(true);
    }

    protected JComponent getPageContents(String id) {
        JComponent contents = this.pageControlsMap.get(id);
        IWizard wizard = this.getWizard();
        if (contents == null && wizard != null) {
            IWizardPage page = wizard.getPage(id);
            contents = page.createControls();
            this.pageControlsMap.put(id, contents);
        }
        return contents;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    protected JComponent createContainer() {
        this.pagePanel = new JPanel(new BorderLayout());
        return this.pagePanel;
    }

    @Override
    protected List<JButton> createButtons() {
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.helpActionPerformed();
            }
        });
        this.backButton = new JButton("< Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.backActionPerformed();
            }
        });
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.nextActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.cancelActionPerformed();
            }
        });
        this.finishButton = new JButton("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.finishActionPerformed();
            }
        });
        this.nextButton.setDefaultCapable(true);
        return Arrays.asList(this.backButton, this.nextButton, DialogButtonsPanel.SEPARATOR, this.cancelButton, DialogButtonsPanel.SEPARATOR, this.finishButton, DialogButtonsPanel.SEPARATOR, this.helpButton);
    }

    private void helpActionPerformed() {
        IWizard wizard = this.currentPage.getWizard();
        HelpContext context = this.currentPage.getHelpContext();
        if (context == null) {
            context = wizard.getHelpContext();
        }
        if (context == null) {
            context = new HelpContext("__default__");
        }
        if (context != null) {
            try {
                Help.getDefault().showHelp(context);
            }
            catch (HelpException ex) {
                ExceptionDialog dlg = new ExceptionDialog((Window)this, ex);
                dlg.setVisible(true);
            }
        }
    }

    private void backActionPerformed() {
        this.setCurrentPage(this.pageHistory.pop(), false);
    }

    private void nextActionPerformed() {
        if (this.currentPage == null) {
            return;
        }
        IWizard wizard = this.getWizard();
        this.setCurrentPage(wizard.getNextPage(this.currentPage));
    }

    private void finishActionPerformed() {
        if (this.currentPage != null) {
            this.currentPage.updateModel();
            this.currentPage.getWizard().pageLeft(this.currentPage);
            this.currentPage.getWizard().performFinish();
        }
        this.cancelled = false;
        this.setVisible(false);
    }

    private void cancelActionPerformed() {
        if (this.currentPage != null) {
            this.currentPage.getWizard().performCancel();
        }
        this.cancelled = true;
        this.setVisible(false);
    }

    public void updateState() {
        if (this.currentPage != null) {
            DialogHeaderPanel header = this.getHeaderPanel();
            header.setTitle(this.currentPage.getTitle());
            header.setLeftLogo(this.currentPage.getLogo());
            header.setMessageStatus(this.currentPage.getStatus());
            header.setMessage(this.currentPage.getMessage());
            IWizard wizard = this.getWizard();
            this.setTitle(wizard.getTitle());
        }
        this.updateButtons();
    }
}

