/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gitools.ui.platform.dialog.AbstractDialog;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.help.Help;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.help.HelpException;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.IWizardPageUpdateListener;

public class PageDialog
extends AbstractDialog {
    private IWizardPage page;
    private boolean cancelled;
    private JButton cancelButton;
    private JButton finishButton;
    private JButton helpButton;
    protected JPanel pagePanel;

    public PageDialog(Window owner, IWizardPage page) {
        super(owner, page.getTitle(), page.getLogo());
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLocationRelativeTo(owner);
        this.page = page;
        this.cancelled = true;
        page.addPageUpdateListener(new IWizardPageUpdateListener(){

            @Override
            public void pageUpdated(IWizardPage page) {
                PageDialog.this.updateState();
            }
        });
        JComponent contents = page.createControls();
        this.pagePanel.add((Component)contents, "Center");
        contents.repaint();
        this.updateState();
        page.updateControls();
    }

    @Override
    protected JComponent createContainer() {
        this.pagePanel = new JPanel(new BorderLayout());
        return this.pagePanel;
    }

    @Override
    protected List<JButton> createButtons() {
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageDialog.this.helpActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageDialog.this.cancelActionPerformed();
            }
        });
        this.finishButton = new JButton("Ok");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageDialog.this.finishActionPerformed();
            }
        });
        this.finishButton.setDefaultCapable(true);
        return Arrays.asList(this.cancelButton, this.finishButton, this.helpButton);
    }

    private void helpActionPerformed() {
        HelpContext context = this.page.getHelpContext();
        if (context != null) {
            try {
                Help.getDefault().showHelp(context);
            }
            catch (HelpException ex) {
                ExceptionDialog dlg = new ExceptionDialog((Window)this, ex);
                dlg.setVisible(true);
            }
        }
    }

    private void cancelActionPerformed() {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void finishActionPerformed() {
        this.page.updateModel();
        this.cancelled = false;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void updateState() {
        DialogHeaderPanel header = this.getHeaderPanel();
        header.setTitle(this.page.getTitle());
        header.setLeftLogo(this.page.getLogo());
        header.setMessageStatus(this.page.getStatus());
        header.setMessage(this.page.getMessage());
        this.updateButtons();
    }

    private void updateButtons() {
        this.finishButton.setEnabled(this.page.isComplete());
        this.cancelButton.setEnabled(true);
    }
}

