/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.IWizardPageUpdateListener;

public abstract class AbstractWizardPage
extends JPanel
implements IWizardPage {
    private static final long serialVersionUID = -4330234851091328953L;
    private String id;
    private IWizard wizard;
    private boolean pageComplete;
    private String title = "";
    private Icon logo;
    private MessageStatus status = MessageStatus.INFO;
    private String message = "";
    private HelpContext helpContext;
    private List<IWizardPageUpdateListener> listeners = new ArrayList<IWizardPageUpdateListener>();

    public AbstractWizardPage() {
        this((String)null);
    }

    public AbstractWizardPage(String id) {
        this.id = id != null ? id : this.getClass().getCanonicalName();
        this.pageComplete = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IWizard getWizard() {
        return this.wizard;
    }

    @Override
    public void setWizard(IWizard wizard) {
        this.wizard = wizard;
    }

    @Override
    public boolean isComplete() {
        return this.pageComplete;
    }

    public void setComplete(boolean complete) {
        this.pageComplete = complete;
        this.fireUpdated();
    }

    @Override
    public JComponent createControls() {
        return this;
    }

    @Override
    public void updateControls() {
    }

    @Override
    public void updateModel() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireUpdated();
    }

    @Override
    public Icon getLogo() {
        return this.logo;
    }

    public void setLogo(Icon logo) {
        this.logo = logo;
    }

    @Override
    public MessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(MessageStatus status) {
        this.status = status;
        this.fireUpdated();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.fireUpdated();
    }

    @Override
    public HelpContext getHelpContext() {
        return this.helpContext;
    }

    @Override
    public void addPageUpdateListener(IWizardPageUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePageUpdateListener(IWizardPageUpdateListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setHelpContext(HelpContext helpContext) {
        this.helpContext = helpContext;
    }

    public void setMessage(MessageStatus status, String message) {
        this.status = status;
        this.message = message;
        this.fireUpdated();
    }

    protected void fireUpdated() {
        for (IWizardPageUpdateListener l : this.listeners) {
            l.pageUpdated(this);
        }
    }
}

