/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.IWizardPageUpdateListener;
import org.gitools.ui.platform.wizard.IWizardUpdateListener;

public abstract class AbstractWizard
implements IWizard,
IWizardPageUpdateListener {
    private String title;
    private Icon logo;
    private HelpContext helpContext;
    protected IWizardPage currentPage;
    private List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private Map<String, IWizardPage> pageIdMap = new HashMap<String, IWizardPage>();
    private List<IWizardUpdateListener> listeners = new ArrayList<IWizardUpdateListener>();

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireWizardUpdate();
    }

    @Override
    public Icon getLogo() {
        return this.logo;
    }

    public void setLogo(Icon icon) {
        this.logo = icon;
        this.fireWizardUpdate();
    }

    @Override
    public HelpContext getHelpContext() {
        return this.helpContext;
    }

    public void setHelpContext(HelpContext helpContext) {
        this.helpContext = helpContext;
    }

    public void setHelpContext(String helpContextId) {
        this.helpContext = new HelpContext(helpContextId);
    }

    public void addPage(IWizardPage page) {
        String id = page.getId();
        if (id == null) {
            id = "Page" + this.pages.size();
        }
        this.addPage(id, page);
    }

    public void addPage(String id, IWizardPage page) {
        page.setId(id);
        page.setWizard(this);
        this.pages.add(page);
        this.pageIdMap.put(id, page);
        page.addPageUpdateListener(this);
    }

    @Override
    public IWizardPage getStartingPage() {
        return this.pages.size() > 0 ? this.pages.get(0) : null;
    }

    @Override
    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(IWizardPage currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        int idx = this.pages.indexOf(page);
        return idx == -1 || idx == this.pages.size() - 1 ? null : this.pages.get(idx + 1);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        int idx = this.pages.indexOf(page);
        return idx == -1 || idx == 0 ? null : this.pages.get(idx - 1);
    }

    @Override
    public boolean isLastPage(IWizardPage page) {
        return page.equals(this.pages.get(this.pages.size() - 1));
    }

    @Override
    public IWizardPage getPage(String id) {
        return this.pageIdMap.get(id);
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] pagesArray = new IWizardPage[this.pages.size()];
        this.pages.toArray(pagesArray);
        return pagesArray;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public void pageLeft(IWizardPage currentPage) {
    }

    @Override
    public void pageEntered(IWizardPage page) {
    }

    @Override
    public boolean canFinish() {
        return this.currentPage != null ? this.currentPage.isComplete() && this.isLastPage(this.currentPage) : false;
    }

    @Override
    public void performFinish() {
    }

    @Override
    public void performCancel() {
    }

    @Override
    public void addWizardUpdateListener(IWizardUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeWizardUpdateListener(IWizardUpdateListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void pageUpdated(IWizardPage page) {
        for (IWizardUpdateListener l : this.listeners) {
            l.pageUpdated(page);
        }
    }

    private void fireWizardUpdate() {
        for (IWizardUpdateListener l : this.listeners) {
            l.wizardUpdated(this);
        }
    }
}

