/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.progress;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.progress.JobProgressDialog;
import org.gitools.ui.platform.progress.JobProgressMonitor;
import org.gitools.ui.platform.progress.JobRunnable;

public class JobThread
implements JobRunnable {
    private Window parent;
    private JobRunnable runnable;
    private Thread thread;
    private JobProgressDialog dlg;
    private JobProgressMonitor monitor;

    public static void execute(Window parent, JobRunnable runnable) {
        new JobThread(parent, runnable).execute();
    }

    public JobThread(Window parent, JobRunnable runnable) {
        this.parent = parent;
        this.runnable = runnable;
    }

    public JobThread(Window parent) {
        this.parent = parent;
        this.runnable = this;
    }

    public Window getParent() {
        return this.parent;
    }

    public Thread getThread() {
        return this.thread;
    }

    public synchronized void setThread(Thread jobThread) {
        this.thread = jobThread;
    }

    private synchronized JobProgressDialog getDlg() {
        if (this.dlg == null) {
            this.dlg = new JobProgressDialog(this.parent, false);
            this.dlg.addCancelListener(new JobProgressDialog.CancelListener(){

                @Override
                public void cancelled() {
                    JobThread.this.cancelJob();
                }
            });
        }
        return this.dlg;
    }

    private synchronized void setDlg(JobProgressDialog dlg) {
        this.dlg = dlg;
    }

    protected void cancelJob() {
        this.getMonitor().cancel();
        this.dlg.setMessage("Cancelling...");
        Timer timer = new Timer("JobThread.cancelJob");
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JobThread jobThread = JobThread.this;
                synchronized (jobThread) {
                    Thread jobThread2 = JobThread.this.getThread();
                    if (jobThread2 != null && jobThread2.isAlive()) {
                        jobThread2.interrupt();
                    }
                }
            }
        }, 250L);
    }

    protected void done() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JobProgressDialog dlg = JobThread.this.getDlg();
                dlg.setVisible(false);
                dlg.dispose();
                JobThread.this.setDlg(null);
            }
        });
    }

    protected synchronized JobProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected synchronized void setMonitor(JobProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void startThread() {
        this.thread = new Thread("JobThread"){

            @Override
            public void run() {
                JobProgressMonitor m = new JobProgressMonitor(JobThread.this.getDlg(), System.out, false, false);
                JobThread.this.setMonitor(m);
                try {
                    JobThread.this.runnable.run(JobThread.this.monitor);
                }
                catch (Throwable cause) {
                    m.exception(cause);
                }
                JobThread.this.done();
                JobThread.this.setThread(null);
                if (JobThread.this.monitor.getCause() != null) {
                    ExceptionDialog ed = new ExceptionDialog(JobThread.this.parent, JobThread.this.monitor.getCause());
                    ed.setVisible(true);
                }
            }
        };
        this.thread.start();
    }

    public void execute() {
        this.startThread();
        this.getDlg().setModal(true);
        this.getDlg().setVisible(true);
    }

    public boolean isCancelled() {
        return this.getMonitor().isCancelled();
    }

    public Throwable getCause() {
        return this.getMonitor().getCause();
    }

    @Override
    public void run(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Opperation should be overrided");
    }
}

