/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.progress;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class JobProgressDialog
extends JDialog {
    protected List<CancelListener> listeners = new ArrayList<CancelListener>();
    private JButton cancelBtn;
    private JLabel infoLabel;
    private JLabel msgLabel;
    private JProgressBar progressBar;

    public JobProgressDialog(Window parent, boolean modal) {
        super(parent);
        this.setModal(modal);
        this.initComponents();
        this.msgLabel.setText("");
        this.infoLabel.setText("");
        this.progressBar.setMinimum(0);
        this.progressBar.setIndeterminate(true);
    }

    public void addCancelListener(CancelListener listener) {
        this.listeners.add(listener);
    }

    private void initComponents() {
        this.msgLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelBtn = new JButton();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setText("Working...");
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JobProgressDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.infoLabel.setText("info");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, 551, Short.MAX_VALUE).addComponent(this.msgLabel, -2, 551, -2).addComponent(this.infoLabel, -2, 551, -2).addComponent(this.cancelBtn, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelBtn).addContainerGap()));
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        for (CancelListener listener : this.listeners) {
            listener.cancelled();
        }
    }

    public void setMessage(String msg) {
        this.msgLabel.setText(msg);
        this.infoLabel.setText("");
    }

    public void setMessage(String msg, String info) {
        this.msgLabel.setText(msg);
        this.infoLabel.setText(info);
    }

    public void setInfo(String info) {
        this.infoLabel.setText(info);
    }

    public void setWork(int work) {
        this.progressBar.setMaximum(work);
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(progress);
        }
    }

    public static interface CancelListener {
        public void cancelled();
    }
}

