/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gitools.ui.platform.PropertiesExpansion;
import org.gitools.ui.platform.help.DesktopNavigatorHelp;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.help.HelpException;

public abstract class Help {
    private static Help instance;
    protected PropertiesExpansion properties;
    protected List<UrlMap> urlMap;

    public Help() {
        this(new Properties(), new ArrayList<UrlMap>());
    }

    protected Help(Properties properties, List<UrlMap> urlMap) {
        this.properties = new PropertiesExpansion(properties);
        this.urlMap = urlMap;
    }

    public static Help getDefault() {
        if (instance == null) {
            instance = new DesktopNavigatorHelp();
        }
        return instance;
    }

    public void loadProperties(InputStream in) throws IOException {
        this.properties.load(in);
        in.close();
    }

    public void loadUrlMap(InputStream in) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int lineNum = 1;
        while ((line = br.readLine()) != null) {
            if (!(line = line.trim()).isEmpty()) {
                String[] fields = line.split("\t");
                if (fields.length == 2) {
                    this.urlMap.add(new UrlMap(Pattern.compile(fields[0]), fields[1]));
                } else {
                    throw new Exception("Error reading help url mappings: Two columns expected at line " + lineNum);
                }
            }
            ++lineNum;
        }
        br.close();
    }

    protected URL getHelpUrl(HelpContext context) throws MalformedURLException {
        String id = context.getId();
        String urlStr = null;
        for (UrlMap map : this.urlMap) {
            Matcher matcher = map.getPattern().matcher(id);
            if (!matcher.matches()) continue;
            Properties p = new Properties(this.properties);
            for (int i = 0; i < matcher.groupCount(); ++i) {
                p.setProperty("" + i, matcher.group(i));
            }
            urlStr = this.expandPattern(this.properties, map.getUrl());
            break;
        }
        return new URL(urlStr);
    }

    public abstract void showHelp(HelpContext var1) throws HelpException;

    private String expandPattern(Properties properties, String pattern) {
        StringBuilder output = new StringBuilder();
        StringBuilder var = new StringBuilder();
        int state = 67;
        int pos = 0;
        while (pos < pattern.length()) {
            char ch = pattern.charAt(pos++);
            switch (state) {
                case 67: {
                    if (ch == '$') {
                        state = 36;
                        break;
                    }
                    output.append(ch);
                    break;
                }
                case 36: {
                    if (ch == '{') {
                        state = 86;
                        break;
                    }
                    output.append('$').append(ch);
                    state = 67;
                    break;
                }
                case 86: {
                    if (ch == '}') {
                        state = 88;
                        break;
                    }
                    var.append(ch);
                    break;
                }
                case 88: {
                    output.append(properties.getProperty(var.toString()));
                    var.setLength(0);
                    --pos;
                    state = 67;
                }
            }
        }
        switch (state) {
            case 36: {
                output.append('$');
                break;
            }
            case 86: {
                output.append("${").append((CharSequence)var);
                break;
            }
            case 88: {
                output.append(properties.getProperty(var.toString()));
            }
        }
        return output.toString();
    }

    public static class UrlMap {
        private Pattern pattern;
        private String url;

        public UrlMap(Pattern pattern, String url) {
            this.pattern = pattern;
            this.url = url;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

