/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gitools.ui.platform.actions.ActionManager;
import org.gitools.ui.platform.editor.AbstractEditor;

public class MultiEditor
extends AbstractEditor {
    private static final long serialVersionUID = -6013660760909524202L;
    private JTabbedPane tabbedPane;

    public MultiEditor() {
        this.createComponents();
    }

    private void createComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AbstractEditor editor = MultiEditor.this.getSelectedEditor();
                ActionManager.getDefault().updateEnabledByEditor(editor);
                editor.doVisible();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    protected void addView(AbstractEditor view, String title) {
        this.tabbedPane.add((Component)view, title);
    }

    protected AbstractEditor getSelectedEditor() {
        return (AbstractEditor)this.tabbedPane.getSelectedComponent();
    }

    @Override
    public Object getModel() {
        return this.getSelectedEditor().getModel();
    }

    @Override
    public boolean isDirty() {
        return this.getSelectedEditor().isDirty();
    }

    @Override
    public boolean isSaveAsAllowed() {
        return this.getSelectedEditor().isSaveAsAllowed();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.getSelectedEditor().doSave(monitor);
    }

    @Override
    public void doSaveAs(IProgressMonitor monitor) {
        this.getSelectedEditor().doSaveAs(monitor);
    }

    @Override
    public void doVisible() {
        this.getSelectedEditor().doVisible();
    }

    @Override
    public void refresh() {
        this.getSelectedEditor().refresh();
    }
}

