/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.w3c.dom.html2.HTMLElement;

public class Html4Editor
extends AbstractEditor {
    private String title;
    protected HtmlPanel panel;
    protected SimpleHtmlRendererContext rcontext;

    public Html4Editor(String title) {
        this.title = title;
        this.createComponents();
    }

    @Override
    public String getName() {
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Object getModel() {
        return null;
    }

    private void createComponents() {
        this.panel = new HtmlPanel();
        this.rcontext = new LocalHtmlRendererContext(this.panel, (UserAgentContext)new SimpleUserAgentContext());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
    }

    protected void linkClicked(HTMLElement linkNode, URL url, String target) throws LinkVetoException {
        String rel = linkNode.getAttribute("rel");
        String href = linkNode.getAttribute("href");
        if (rel != null && rel.equalsIgnoreCase("action")) {
            String name = href;
            HashMap<String, String> params = new HashMap<String, String>();
            int pos = href.indexOf(63);
            if (pos >= 0) {
                String p1;
                name = href.substring(0, pos);
                String string = p1 = pos < href.length() ? href.substring(pos + 1) : "";
                if (!p1.isEmpty()) {
                    String[] p2;
                    for (String p3 : p2 = p1.split("\\&")) {
                        pos = p3.indexOf(61);
                        if (pos <= 0) continue;
                        String id = p3.substring(0, pos);
                        String value = pos < p3.length() ? p3.substring(pos + 1) : "";
                        params.put(id, value);
                    }
                }
            }
            this.performUrlAction(name, params);
            throw new LinkVetoException();
        }
        if (target != null && target.equalsIgnoreCase("_external")) {
            try {
                Desktop.getDesktop().browse(new URI(href));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new LinkVetoException();
        }
    }

    protected void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) throws LinkVetoException {
    }

    protected void performUrlAction(String name, Map<String, String> params) {
    }

    public void navigate(URL url) throws Exception {
        this.rcontext.navigate(url, "_this");
    }

    public HtmlRendererContext getHtmlRenderContext() {
        return this.rcontext;
    }

    private class LocalHtmlRendererContext
    extends SimpleHtmlRendererContext {
        public LocalHtmlRendererContext(HtmlPanel panel, UserAgentContext userAgentContext) {
            super(panel, userAgentContext);
        }

        public void onMouseOver(HTMLElement element, MouseEvent event) {
            super.onMouseOver(element, event);
            Cursor cursor = null;
            cursor = "a".equalsIgnoreCase(element.getTagName()) ? new Cursor(12) : new Cursor(0);
            Html4Editor.this.setCursor(cursor);
        }

        public void onMouseOut(HTMLElement element, MouseEvent event) {
            super.onMouseOut(element, event);
            Cursor cursor = new Cursor(0);
            Html4Editor.this.setCursor(cursor);
        }

        public void linkClicked(HTMLElement linkNode, URL url, String target) {
            try {
                Html4Editor.this.linkClicked(linkNode, url, target);
                super.linkClicked(linkNode, url, target);
            }
            catch (LinkVetoException ex) {
                // empty catch block
            }
        }

        public void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) {
            try {
                Html4Editor.this.submitForm(method, action, target, enctype, formInputs);
                super.submitForm(method, action, target, enctype, formInputs);
            }
            catch (LinkVetoException ex) {
                // empty catch block
            }
        }
    }

    public static class LinkVetoException
    extends Exception {
    }
}

