/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gitools.ui.platform.actions.ActionManager;
import org.gitools.ui.platform.component.EditorTabComponent;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.IEditor;

public class EditorsPanel
extends JTabbedPane {
    private static final long serialVersionUID = 2170150185478413716L;
    public static final String DEFAULT_NAME_PREFIX = "unnamed";
    private Map<String, Integer> nameCounts = new HashMap<String, Integer>();

    public EditorsPanel() {
        this.createComponents();
        this.setTabLayoutPolicy(1);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AbstractEditor selectedEditor = EditorsPanel.this.getSelectedEditor();
                if (selectedEditor != null) {
                    selectedEditor.doVisible();
                }
                EditorsPanel.this.refreshActions();
            }
        });
    }

    private void createComponents() {
    }

    public void addEditor(AbstractEditor editor) {
        if (editor == null) {
            return;
        }
        String name = editor.getName() != null ? editor.getName() : this.createName();
        Icon icon = editor.getIcon();
        if (icon == null) {
            this.addTab(name, editor);
        } else {
            this.addTab(name, icon, editor);
        }
        this.setTabComponentAt(this.getTabCount() - 1, new EditorTabComponent(this, editor));
        this.refreshActions();
        this.setSelectedComponent(editor);
    }

    public void removeEditor(AbstractEditor editor) {
        if (editor == null) {
            return;
        }
        if (editor.doClose()) {
            int i = this.indexOfComponent(editor);
            if (i != -1) {
                this.remove(i);
            }
            this.refreshActions();
        }
    }

    public AbstractEditor getSelectedEditor() {
        return (AbstractEditor)this.getSelectedComponent();
    }

    public void refreshActions() {
        AbstractEditor editor = this.getSelectedEditor();
        ActionManager.getDefault().updateEnabledByEditor(editor);
    }

    public String createName() {
        return this.createName(DEFAULT_NAME_PREFIX, "");
    }

    public String createName(String prefix, String suffix) {
        HashSet<String> names = new HashSet<String>();
        int numTabs = this.getTabCount();
        for (int i = 0; i < numTabs; ++i) {
            IEditor editor = (IEditor)((Object)this.getComponentAt(i));
            names.add(editor.getName());
        }
        Integer c = this.nameCounts.get(prefix = prefix.replace(" ", "_"));
        if (c == null) {
            c = 0;
        }
        int nameCount = c;
        String name = prefix + "-" + nameCount++ + suffix;
        while (names.contains(name)) {
            name = prefix + "-" + nameCount++ + suffix;
        }
        this.nameCounts.put(prefix, nameCount);
        return name;
    }

    public String deriveName(String name, String removeExtension, String prefixAdd, String newExtension) {
        int i;
        if (!removeExtension.isEmpty() && name.endsWith(removeExtension)) {
            int endIndex = name.length() - removeExtension.length() - 1;
            name = endIndex >= 0 ? name.substring(0, endIndex) : "";
        }
        for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
        }
        if (name.charAt(i) != '-') {
            ++i;
        }
        if (!(name = name.substring(0, i)).endsWith(prefixAdd)) {
            name = name + prefixAdd;
        }
        return this.createName(name, "." + newExtension);
    }

    private EditorTabComponent getEditorTab(IEditor editor) {
        int index = this.getEditorIndex(editor);
        return (EditorTabComponent)this.getTabComponentAt(index);
    }

    private int getEditorIndex(IEditor editor) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != editor) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedEditor(AbstractEditor editor) {
        this.setSelectedComponent(editor);
    }
}

