/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gitools.ui.platform.editor.IEditor;
import org.gitools.ui.platform.view.AbstractView;

public abstract class AbstractEditor
extends AbstractView
implements IEditor {
    private static final long serialVersionUID = -2379950551933668781L;
    private File file;
    private boolean dirty = false;
    private boolean saveAsAllowed = false;
    private List<EditorListener> listeners = new ArrayList<EditorListener>();

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        if (oldName == null || !oldName.equals(name)) {
            super.setName(name);
            for (EditorListener l : this.listeners) {
                l.nameChanged(this);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (this.file != file || !this.file.equals(file)) {
            this.file = file;
            for (EditorListener l : this.listeners) {
                l.fileChanged(this);
            }
            this.setName(file.getName());
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
    }

    @Override
    public boolean isSaveAsAllowed() {
        return this.saveAsAllowed;
    }

    public void setSaveAsAllowed(boolean saveAsAllowed) {
        this.saveAsAllowed = saveAsAllowed;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        for (EditorListener l : this.listeners) {
            l.saved(this);
        }
    }

    @Override
    public void doSaveAs(IProgressMonitor monitor) {
        for (EditorListener l : this.listeners) {
            l.saved(this);
        }
    }

    @Override
    public void doVisible() {
    }

    @Override
    public boolean doClose() {
        return true;
    }

    public void addEditorListener(EditorListener listener) {
        this.listeners.add(listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.listeners.add(listener);
    }

    public static abstract class EditorListener {
        public void nameChanged(IEditor editor) {
        }

        public void fileChanged(IEditor editor) {
        }

        public void dirtyChanged(IEditor editor) {
        }

        public void saved(IEditor editor) {
        }
    }
}

