/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserDialog
extends JDialog {
    private static final int[] STYLES = new int[]{0, 1, 2, 3};
    private static final String[] STYLE_NAMES = new String[]{"Normal", "Bold", "Italic", "Bold Italic"};
    private boolean cancelled = true;
    private JButton acceptBtn;
    private JButton cancelBtn;
    private JList fontFamily;
    private JSpinner fontSize;
    private JComboBox fontStyle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel preview;

    public FontChooserDialog(Font font) {
        this(null, font);
    }

    public FontChooserDialog(Frame parent, Font font) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.acceptBtn);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontFamily.setListData(gEnv.getAvailableFontFamilyNames());
        this.fontFamily.setSelectedValue(font.getFamily(), true);
        this.fontStyle.setModel(new DefaultComboBoxModel<String>(STYLE_NAMES));
        for (int i = 0; i < STYLES.length; ++i) {
            if (STYLES[i] != font.getStyle()) continue;
            this.fontStyle.setSelectedIndex(i);
        }
        this.fontSize.setValue(font.getSize());
    }

    private void updatePreview() {
        Font font = this.getFont();
        if (font != null) {
            this.preview.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        try {
            String name = (String)this.fontFamily.getSelectedValue();
            int style = STYLES[this.fontStyle.getSelectedIndex()];
            int size = (Integer)this.fontSize.getValue();
            return new Font(name, style, size);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fontFamily = new JList();
        this.jLabel2 = new JLabel();
        this.fontStyle = new JComboBox();
        this.jLabel3 = new JLabel();
        this.fontSize = new JSpinner();
        this.preview = new JLabel();
        this.cancelBtn = new JButton();
        this.acceptBtn = new JButton();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Choose font...");
        this.setLocationByPlatform(true);
        this.jLabel1.setText("Name");
        this.fontFamily.setSelectionMode(0);
        this.fontFamily.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserDialog.this.fontFamilyValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fontFamily);
        this.jLabel2.setText("Style");
        this.fontStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserDialog.this.fontStyleActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Size");
        this.fontSize.setModel(new SpinnerNumberModel());
        this.fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FontChooserDialog.this.fontSizeStateChanged(evt);
            }
        });
        this.preview.setBackground(Color.white);
        this.preview.setHorizontalAlignment(0);
        this.preview.setText("ABCDEFGH ijklmnopq");
        this.preview.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.preview.setFocusable(false);
        this.preview.setOpaque(true);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.acceptBtn.setText("Accept");
        this.acceptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserDialog.this.acceptBtnActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Preview");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontStyle, 0, 210, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.fontSize, -2, 59, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.acceptBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelBtn)).addComponent(this.jSeparator1, -1, 376, Short.MAX_VALUE).addComponent(this.preview, -1, 376, Short.MAX_VALUE).addComponent(this.jLabel5).addComponent(this.jSeparator2, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 154, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fontStyle, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.fontSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preview, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn).addComponent(this.acceptBtn)).addContainerGap()));
        this.pack();
    }

    private void fontFamilyValueChanged(ListSelectionEvent evt) {
        this.updatePreview();
    }

    private void fontStyleActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void fontSizeStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    private void acceptBtnActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setVisible(false);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }
}

