/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.dialog;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ExceptionDialog
extends JDialog {
    private Throwable cause;
    private JButton closeButton;
    private JButton copyButton;
    private JTextArea descriptionArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextArea traceArea;

    public static void show(Window parent, Throwable cause) {
        ExceptionDialog dlg = new ExceptionDialog(parent, cause);
        dlg.setVisible(true);
    }

    public ExceptionDialog(Window parent, Throwable cause) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.cause = cause;
        this.descriptionArea.setText(cause.getLocalizedMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        pw.close();
        this.traceArea.setText(sw.toString());
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.copyButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.traceArea = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.setTitle("There was an error...");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExceptionDialog.this.closeDialog(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.copyButton.setText("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionDialog.this.copyButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Description");
        this.jLabel2.setText("Trace");
        this.descriptionArea.setColumns(20);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setRows(2);
        this.jScrollPane1.setViewportView(this.descriptionArea);
        this.traceArea.setColumns(20);
        this.traceArea.setRows(5);
        this.jScrollPane2.setViewportView(this.traceArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -1, 451, Short.MAX_VALUE).addGap(180, 180, 180)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 619, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 521, Short.MAX_VALUE).addComponent(this.closeButton)).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 619, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 619, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 619, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 59, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 193, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyButton).addComponent(this.closeButton)).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.cause.getMessage());
        this.cause.printStackTrace(pw);
        pw.close();
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(sw.toString());
        cb.setContents(ss, ss);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

