/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.dialog;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gitools.ui.platform.dialog.MessageStatus;

public class DialogHeaderPanel
extends JPanel {
    private static final Color INFO_COLOR = Color.WHITE;
    private static final Color WARN_COLOR = new Color(250, 250, 160);
    private static final Color ERROR_COLOR = new Color(250, 150, 150);
    private static final Color PROGRESS_COLOR = new Color(100, 180, 250);
    private MessageStatus messageStatus;
    private String leftLogoLink;
    private String rightLogoLink;
    private JLabel leftLogo;
    private JLabel message;
    private JLabel rightLogo;
    private JLabel title;

    public DialogHeaderPanel() {
        this.initComponents();
        this.title.setFont(this.title.getFont().deriveFont(1, 16.0f));
        this.title.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.message.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.messageStatus = MessageStatus.INFO;
        this.leftLogo.setText("");
        this.leftLogo.setVisible(false);
        this.rightLogo.setText("");
    }

    public DialogHeaderPanel(String header, String message, MessageStatus status, Icon logo) {
        this();
        this.setTitle(header);
        this.setMessageStatus(status);
        this.setMessage(message);
        this.setRightLogo(logo);
    }

    private void initComponents() {
        this.title = new JLabel();
        this.message = new JLabel();
        this.rightLogo = new JLabel();
        this.leftLogo = new JLabel();
        this.setBackground(Color.white);
        this.setFocusable(false);
        this.title.setText("Title");
        this.title.setFocusable(false);
        this.title.setRequestFocusEnabled(false);
        this.message.setBackground(Color.white);
        this.message.setText("Message");
        this.message.setVerticalAlignment(1);
        this.message.setFocusable(false);
        this.message.setOpaque(true);
        this.message.setRequestFocusEnabled(false);
        this.message.setVerticalTextPosition(1);
        this.rightLogo.setText("RightLogo");
        this.rightLogo.setVerticalAlignment(1);
        this.rightLogo.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.rightLogo.setFocusable(false);
        this.rightLogo.setRequestFocusEnabled(false);
        this.rightLogo.setVerticalTextPosition(1);
        this.rightLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogHeaderPanel.this.rightLogoMouseClicked(evt);
            }
        });
        this.leftLogo.setText("LeftLogo");
        this.leftLogo.setVerticalAlignment(1);
        this.leftLogo.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.leftLogo.setFocusable(false);
        this.leftLogo.setRequestFocusEnabled(false);
        this.leftLogo.setVerticalTextPosition(1);
        this.leftLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogHeaderPanel.this.leftLogoMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.leftLogo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.message, -1, 371, Short.MAX_VALUE).addComponent(this.title, -1, 371, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rightLogo)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.title).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.message).addContainerGap(28, Short.MAX_VALUE)).addComponent(this.leftLogo, -1, 86, Short.MAX_VALUE).addComponent(this.rightLogo, -1, 86, Short.MAX_VALUE));
    }

    private void rightLogoMouseClicked(MouseEvent evt) {
        if (this.rightLogoLink != null) {
            try {
                Desktop.getDesktop().browse(new URL(this.rightLogoLink).toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void leftLogoMouseClicked(MouseEvent evt) {
        if (this.leftLogoLink != null) {
            try {
                Desktop.getDesktop().browse(new URL(this.leftLogoLink).toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public Font getTitleFont() {
        return this.title.getFont();
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    public Color getTitleColor() {
        return this.title.getForeground();
    }

    public void setTitleColor(Color color) {
        this.title.setForeground(color);
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public MessageStatus getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageStatus status) {
        this.messageStatus = status;
        switch (status) {
            case INFO: {
                this.message.setBackground(INFO_COLOR);
                break;
            }
            case WARN: {
                this.message.setBackground(WARN_COLOR);
                break;
            }
            case ERROR: {
                this.message.setBackground(ERROR_COLOR);
                break;
            }
            case PROGRESS: {
                this.message.setBackground(PROGRESS_COLOR);
            }
        }
    }

    public Icon getRightLogo() {
        return this.rightLogo.getIcon();
    }

    public void setRightLogo(Icon logo) {
        this.rightLogo.setIcon(logo);
    }

    public String getRightLogoLink() {
        return this.rightLogoLink;
    }

    public void setRightLogoLink(String logoLink) {
        this.rightLogoLink = logoLink;
        if (logoLink == null) {
            this.rightLogo.setCursor(Cursor.getDefaultCursor());
        } else {
            this.rightLogo.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public Icon getLeftLogo() {
        return this.leftLogo.getIcon();
    }

    public void setLeftLogo(Icon logo) {
        this.leftLogo.setIcon(logo);
        this.leftLogo.setVisible(logo != null);
    }

    public String getLeftLogoLink() {
        return this.leftLogoLink;
    }

    public void setLeftLogoLink(String logoLink) {
        this.leftLogoLink = logoLink;
        if (logoLink == null) {
            this.leftLogo.setCursor(Cursor.getDefaultCursor());
        } else {
            this.leftLogo.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public boolean isLeftLogoVisible() {
        return this.leftLogo.isVisible();
    }
}

