/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.gitools.ui.platform.dialog.DialogButtonsPanel;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.MessageStatus;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = 5886096207448862426L;
    private DialogHeaderPanel hdrPanel;
    protected JComponent container;

    public AbstractDialog(Window owner, String title, String header, String message, MessageStatus status, Icon logo) {
        super(owner, title);
        this.setModal(true);
        this.createComponents(header, message, status, logo);
        this.setLocationRelativeTo(owner);
        this.setMinimumSize(new Dimension(300, 260));
    }

    public AbstractDialog(Window owner, String title, Icon icon) {
        this(owner, title, "", "", MessageStatus.INFO, icon);
    }

    public void open() {
        this.setVisible(true);
    }

    protected JComponent getContainer() {
        return this.container;
    }

    protected void setContainer(JComponent container) {
        this.container = container;
    }

    protected void createComponents(String header, String message, MessageStatus status, Icon logo) {
        this.hdrPanel = new DialogHeaderPanel();
        this.hdrPanel.setTitle(header);
        this.hdrPanel.setMessage(message);
        this.hdrPanel.setMessageStatus(status);
        this.hdrPanel.setRightLogo(logo);
        JPanel hp = new JPanel();
        hp.setLayout(new BorderLayout());
        hp.add((Component)this.hdrPanel, "Center");
        hp.add((Component)new JSeparator(0), "South");
        this.container = this.createContainer();
        DialogButtonsPanel buttonsPanel = new DialogButtonsPanel(this.createButtons());
        JPanel bp = new JPanel();
        bp.setLayout(new BorderLayout());
        bp.add((Component)new JSeparator(0), "North");
        bp.add((Component)buttonsPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)hp, "North");
        if (this.container != null) {
            this.add((Component)this.container, "Center");
        }
        this.add((Component)bp, "South");
    }

    public DialogHeaderPanel getHeaderPanel() {
        return this.hdrPanel;
    }

    protected abstract JComponent createContainer();

    protected abstract List<JButton> createButtons();
}

