/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.component;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.editor.IEditor;

public class EditorTabComponent
extends JPanel {
    private final EditorsPanel editorPanel;
    private final AbstractEditor editor;
    private final JLabel label;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public EditorTabComponent(EditorsPanel editorPanel, AbstractEditor editor) {
        this.editorPanel = editorPanel;
        this.editor = editor;
        editor.addEditorListener(new AbstractEditor.EditorListener(){

            @Override
            public void dirtyChanged(IEditor editor) {
                EditorTabComponent.this.updateLabel();
            }

            @Override
            public void nameChanged(IEditor editor) {
                EditorTabComponent.this.updateLabel();
            }
        });
        this.setOpaque(false);
        this.label = new JLabel();
        this.label.setOpaque(false);
        this.label.setFocusable(false);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorTabComponent.this.editorPanel.setSelectedEditor(EditorTabComponent.this.editor);
            }
        });
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.updateLabel();
        TabButton button = new TabButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.add((Component)button, "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private void updateLabel() {
        if (this.editor.isDirty()) {
            this.label.setFont(this.label.getFont().deriveFont(1));
        } else {
            this.label.setFont(this.label.getFont().deriveFont(0));
        }
        this.label.setText(this.editor.getName());
        String toolTip = null;
        if (this.editor.getFile() != null) {
            toolTip = this.editor.getFile().getAbsolutePath();
        }
        this.label.setToolTipText(toolTip);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 18;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Close this editor");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditorTabComponent.this.editorPanel.removeEditor(EditorTabComponent.this.editor);
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

