/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;

public class ColorChooserLabel
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = -2974772763040220614L;
    private Color color;
    private List<ColorChangeListener> listeners;

    public ColorChooserLabel(Color color, String toolTipText) {
        this.color = color;
        this.setBackground(color);
        this.setToolTipText(toolTipText);
        this.setText("");
        this.listeners = new ArrayList<ColorChangeListener>(1);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Dimension dim = new Dimension(24, 24);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.setOpaque(true);
        this.addMouseListener(this);
    }

    public ColorChooserLabel(Color color) {
        this(color, null);
    }

    public ColorChooserLabel() {
        this(Color.WHITE, null);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color prevColor = this.color;
        this.color = color;
        this.setBackground(color);
        if (!prevColor.equals(color)) {
            this.fireColorChanged(color);
        }
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeColorchangeListener(ColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireColorChanged(Color color) {
        for (ColorChangeListener listener : this.listeners) {
            listener.colorChanged(color);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Color c = JColorChooser.showDialog(this, "Color selection...", this.color);
        if (c != null) {
            this.setColor(c);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static interface ColorChangeListener {
        public void colorChanged(Color var1);
    }
}

