/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.actions;

import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.gitools.ui.platform.actions.SeparatorAction;
import org.gitools.ui.platform.editor.IEditor;

public abstract class BaseAction
extends AbstractAction {
    private static final long serialVersionUID = 8312774908067146251L;
    private static final String CHECK_MODE_PROP = "checkMode";
    private static final String SELECTED_PROP = "selected";
    public static final BaseAction separator = new SeparatorAction();
    private boolean defaultEnabled = false;
    private boolean checkMode;
    private boolean selected;
    private String actionGroup;

    public BaseAction(String name, ImageIcon icon, String desc, Integer mnemonic, boolean checkMode, boolean selected, String actionGroup) {
        super(name, icon);
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        }
        if (mnemonic != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        this.checkMode = checkMode;
        this.selected = selected;
        this.actionGroup = actionGroup;
    }

    public BaseAction(String name, ImageIcon icon, String desc, Integer mnemonic) {
        this(name, icon, desc, mnemonic, false, false, null);
    }

    public BaseAction(String name, ImageIcon icon, boolean checkMode, boolean checked, String actionGroup) {
        this(name, icon, null, null, checkMode, checked, actionGroup);
    }

    public BaseAction(String name, boolean checkMode, boolean checked, String actionGroup) {
        this(name, null, null, null, checkMode, checked, actionGroup);
    }

    public BaseAction(String name, ImageIcon icon, String desc) {
        this(name, icon, desc, null);
    }

    public BaseAction(String name, ImageIcon icon) {
        this(name, icon, null, null);
    }

    public BaseAction(String name) {
        this(name, null, null, null);
    }

    public String getName() {
        return this.getValue("Name").toString();
    }

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setDesc(String desc) {
        this.putValue("ShortDescription", desc);
    }

    protected void setAccelerator(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
    }

    protected void setMnemonic(int vk) {
        this.putValue("MnemonicKey", vk);
    }

    protected ImageIcon getSmallIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    protected void setSmallIcon(ImageIcon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setSmallIconFromResource(String name) {
        this.setSmallIcon(this.getIconResource(name));
    }

    protected ImageIcon getLargeIcon() {
        return (ImageIcon)this.getValue("SwingLargeIconKey");
    }

    protected void setLargeIcon(ImageIcon icon) {
        this.putValue("SwingLargeIconKey", icon);
    }

    protected void setLargeIconFromResource(String name) {
        this.setLargeIcon(this.getIconResource(name));
    }

    private ImageIcon getIconResource(String name) {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            url = this.getClass().getResource("/img/null.gif");
        }
        return new ImageIcon(url);
    }

    public boolean isSeparator() {
        return false;
    }

    public void setDefaultEnabled(boolean defaultEnabled) {
        this.defaultEnabled = defaultEnabled;
        this.setEnabled(defaultEnabled);
    }

    public void setTreeEnabled(boolean enabled) {
        this.setEnabled(enabled);
    }

    public boolean updateEnabledByEditor(IEditor editor) {
        boolean en = this.isEnabledByEditor(editor);
        this.setEnabled(en);
        return en;
    }

    public boolean isEnabledByEditor(IEditor editor) {
        Object model;
        if (editor != null && (model = editor.getModel()) != null) {
            return this.isEnabledByModel(model);
        }
        return this.defaultEnabled;
    }

    public boolean updateEnabledByModel(Object model) {
        boolean en = this.isEnabledByModel(model);
        this.setEnabled(en);
        return en;
    }

    protected boolean isEnabledByModel(Object model) {
        return this.defaultEnabled;
    }

    public boolean isCheckMode() {
        return this.checkMode;
    }

    public void setCheckMode(boolean checkMode) {
        boolean old = this.checkMode;
        this.checkMode = checkMode;
        this.firePropertyChange(CHECK_MODE_PROP, old, checkMode);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean old = this.selected;
        this.selected = selected;
        this.firePropertyChange(SELECTED_PROP, old, selected);
    }

    public String getActionGroup() {
        return this.actionGroup;
    }

    public void setActionGroup(String actionGroup) {
        this.actionGroup = actionGroup;
    }
}

