/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.gitools.ui.platform.actions.ActionSet;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.actions.SeparatorAction;

public class ActionSetUtils {
    public static JToolBar createToolBar(ActionSet actionSet) {
        JToolBar toolBar = new JToolBar();
        HashMap<String, ButtonGroup> groups = new HashMap<String, ButtonGroup>();
        for (BaseAction a : actionSet.getActions()) {
            if (a instanceof SeparatorAction) {
                toolBar.addSeparator();
                continue;
            }
            toolBar.add(ActionSetUtils.createTool(a, groups));
        }
        return toolBar;
    }

    private static JComponent createTool(BaseAction a, Map<String, ButtonGroup> groups) {
        AbstractButton tool = null;
        if (a.isCheckMode()) {
            JToggleButton tbtn = new JToggleButton(a);
            String actionGroup = a.getActionGroup();
            if (actionGroup == null) {
                tbtn.setSelected(a.isSelected());
            } else {
                ButtonGroup g = groups.get(actionGroup);
                if (g == null) {
                    g = new ButtonGroup();
                    groups.put(actionGroup, g);
                }
                g.add(tbtn);
                g.setSelected(tbtn.getModel(), a.isSelected());
            }
            tool = tbtn;
        } else {
            JButton btn = new JButton(a);
            btn.setHideActionText(a.getSmallIcon() != null || a.getLargeIcon() != null);
            tool = btn;
        }
        tool.setFocusable(false);
        tool.setRequestFocusEnabled(false);
        return tool;
    }

    public static JMenuBar createMenuBar(ActionSet actionSet) {
        JMenuBar menuBar = new JMenuBar();
        for (BaseAction a : actionSet.getActions()) {
            menuBar.add(ActionSetUtils.createMenu(a));
        }
        return menuBar;
    }

    public static JMenu createMenu(BaseAction action) {
        JMenu menu = new JMenu(action);
        List<BaseAction> actions = ((ActionSet)action).getActions();
        for (BaseAction a : actions) {
            if (a instanceof SeparatorAction) {
                menu.addSeparator();
                continue;
            }
            if (a instanceof ActionSet) {
                menu.add(ActionSetUtils.createMenu(a));
                continue;
            }
            menu.add(a);
        }
        return menu;
    }
}

