/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform.actions;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.gitools.ui.platform.actions.ActionSet;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.IEditor;

public class ActionManager {
    private static ActionManager defaultActionManager;
    private Set<BaseAction> rootActions = new HashSet<BaseAction>();
    private Set<BaseAction> baseActions = new HashSet<BaseAction>();
    private Map<String, BaseAction> actionMap = new HashMap<String, BaseAction>();

    public static ActionManager getDefault() {
        if (defaultActionManager != null) {
            return defaultActionManager;
        }
        defaultActionManager = new ActionManager();
        return defaultActionManager;
    }

    public BaseAction getAction(String id) {
        return this.actionMap.get(id);
    }

    public void addAction(BaseAction action) {
        this.baseActions.add(action);
        this.actionMap.put(action.getClass().getName(), action);
    }

    public void addAction(BaseAction action, String id) {
        this.baseActions.add(action);
        this.actionMap.put(id, action);
    }

    public void addActionsFromClass(Class<?> cls) {
        for (Field field : cls.getDeclaredFields()) {
            if (!BaseAction.class.isAssignableFrom(field.getType())) continue;
            try {
                this.addAction((BaseAction)field.get(null), field.getName());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void addActionsFromActionSet(ActionSet actionSet) {
        Stack<BaseAction> actionStack = new Stack<BaseAction>();
        actionStack.push(actionSet);
        while (actionStack.size() > 0) {
            BaseAction action = (BaseAction)actionStack.pop();
            this.addAction(action);
            if (!(action instanceof ActionSet)) continue;
            ActionSet as = (ActionSet)action;
            for (BaseAction a : as.getActions()) {
                actionStack.push(a);
            }
        }
    }

    public void addRootAction(BaseAction action) {
        this.rootActions.add(action);
    }

    public void updateEnabledByEditor(IEditor editor) {
        for (BaseAction action : this.rootActions) {
            action.updateEnabledByEditor(editor);
        }
    }
}

