/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.workspace;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.workspace.AbstractNode;
import org.gitools.ui.workspace.WorkspaceProjectNode;
import org.gitools.workspace.Workspace;
import org.gitools.workspace.WorkspaceProjectRef;

public class WorkspaceNode
extends AbstractNode {
    private static final long serialVersionUID = 5411843318201716836L;
    private Workspace workspace;

    public WorkspaceNode(Workspace workspace) {
        this.workspace = workspace;
        for (WorkspaceProjectRef projectRef : workspace.getProjectReferences()) {
            this.add(new WorkspaceProjectNode(projectRef));
        }
    }

    @Override
    public void refresh() {
        WorkspaceProjectNode node;
        HashMap<WorkspaceProjectRef, WorkspaceProjectNode> nodeMap = new HashMap<WorkspaceProjectRef, WorkspaceProjectNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            WorkspaceProjectNode node2 = (WorkspaceProjectNode)e.nextElement();
            nodeMap.put(node2.getProjectRef(), node2);
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            WorkspaceProjectRef project = (WorkspaceProjectRef)entry.getKey();
            node = (WorkspaceProjectNode)entry.getValue();
            File file = PersistenceManager.getDefault().getEntityFile((Object)project).getParentFile();
            if (file == null || file.exists()) continue;
            this.remove(node);
        }
        List projectRefs = this.workspace.getProjectReferences();
        for (WorkspaceProjectRef projectRef : projectRefs) {
            if (nodeMap.containsKey(projectRef)) continue;
            node = new WorkspaceProjectNode(projectRef);
            nodeMap.put(projectRef, node);
            this.add(node);
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getLabel() {
        return "workspace";
    }
}

