/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.workspace;

import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import org.gitools.ui.workspace.FileNode;
import org.gitools.ui.workspace.INavigatorNode;
import org.gitools.ui.workspace.WorkspaceNode;
import org.gitools.workspace.Workspace;
import org.gitools.workspace.WorkspaceManager;

public class NavigatorPanel
extends JPanel {
    private static final long serialVersionUID = 5667653501673874725L;
    private Workspace workspace;
    private JTree tree;

    public NavigatorPanel() {
        this.workspace = WorkspaceManager.getDefault().getWorkspace();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public NavigatorPanel(Workspace workspace) {
        this.workspace = workspace;
        this.createComponents();
    }

    private void createComponents() {
        FileNode rootNode = null;
        File file = new File(System.getProperty("user.dir"));
        rootNode = new FileNode(file);
        this.tree = new JTree(rootNode);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                Object node = event.getPath().getLastPathComponent();
                if (node instanceof INavigatorNode) {
                    ((INavigatorNode)node).expand();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                Object node = event.getPath().getLastPathComponent();
                if (node instanceof INavigatorNode) {
                    ((INavigatorNode)node).collapse();
                }
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                System.out.println("structure changed" + e.getTreePath());
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                System.out.println("nodes removed" + e.getTreePath());
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                System.out.println("nodes inserted" + e.getTreePath());
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                System.out.println("nodes changed" + e.getTreePath());
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.tree);
    }

    public WorkspaceNode getWorkspaceNode() {
        return (WorkspaceNode)this.tree.getModel().getRoot();
    }

    public void refresh() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }
}

